/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.category;

import com.orsoncharts.Range;
import com.orsoncharts.axis.CategoryAxis3D;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.KeyedValues3DItemKey;
import com.orsoncharts.data.Values3D;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.Offset3D;
import com.orsoncharts.graphics3d.Utils2D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.label.ItemLabelPositioning;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.AbstractCategoryRenderer3D;
import com.orsoncharts.renderer.category.CategoryColorSource;
import com.orsoncharts.renderer.category.StandardCategoryColorSource;
import com.orsoncharts.util.ObjectUtils;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AreaRenderer3D
extends AbstractCategoryRenderer3D
implements Serializable {
    private double base = 0.0;
    private Color baseColor = null;
    private double depth = 0.6;
    private double isolatedItemWidthPercent = 0.25;
    private CategoryColorSource clipColorSource = new StandardCategoryColorSource(Color.RED);
    private boolean drawFaceOutlines = true;
    private static final double EPSILON = 0.001;

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
        this.fireChangeEvent(true);
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(Color color) {
        this.baseColor = color;
        this.fireChangeEvent(true);
    }

    public double getDepth() {
        return this.depth;
    }

    public void setDepth(double depth) {
        this.depth = depth;
        this.fireChangeEvent(true);
    }

    public CategoryColorSource getClipColorSource() {
        return this.clipColorSource;
    }

    public void setClipColorSource(CategoryColorSource source) {
        this.clipColorSource = source;
        this.fireChangeEvent(true);
    }

    public boolean getDrawFaceOutlines() {
        return this.drawFaceOutlines;
    }

    public void setDrawFaceOutlines(boolean outline) {
        this.drawFaceOutlines = outline;
        this.fireChangeEvent(true);
    }

    @Override
    public Range findValueRange(Values3D<? extends Number> data) {
        return DataUtils.findValueRange(data, this.base);
    }

    @Override
    public void composeItem(CategoryDataset3D dataset, int series, int row, int column, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        Color c;
        Color color;
        boolean createIsolatedSegment;
        boolean createRightSegment;
        boolean createLeftSegment;
        Number y = (Number)dataset.getValue(series, row, column);
        Number yprev = null;
        if (column > 0) {
            yprev = (Number)dataset.getValue(series, row, column - 1);
        }
        Number ynext = null;
        if (column < dataset.getColumnCount() - 1) {
            ynext = (Number)dataset.getValue(series, row, column + 1);
        }
        CategoryPlot3D plot = this.getPlot();
        CategoryAxis3D rowAxis = plot.getRowAxis();
        CategoryAxis3D columnAxis = plot.getColumnAxis();
        ValueAxis3D valueAxis = plot.getValueAxis();
        Range r = valueAxis.getRange();
        Object seriesKey = dataset.getSeriesKey(series);
        Object rowKey = dataset.getRowKey(row);
        Object columnKey = dataset.getColumnKey(column);
        double rowValue = rowAxis.getCategoryValue((Comparable<?>)rowKey);
        double columnValue = columnAxis.getCategoryValue((Comparable<?>)columnKey);
        double ww = dimensions.getWidth();
        double hh = dimensions.getHeight();
        double dd = dimensions.getDepth();
        boolean leftOpen = false;
        boolean leftClose = false;
        boolean rightOpen = false;
        boolean rightClose = false;
        if (column == 0) {
            createLeftSegment = false;
            if (dataset.getColumnCount() == 1) {
                createRightSegment = false;
                createIsolatedSegment = y != null;
            } else {
                createRightSegment = y != null && ynext != null;
                rightOpen = true;
                rightClose = false;
                createIsolatedSegment = y != null && ynext == null;
            }
        } else if (column == dataset.getColumnCount() - 1) {
            createRightSegment = false;
            createLeftSegment = y != null && yprev != null;
            leftOpen = false;
            leftClose = true;
            createIsolatedSegment = y != null && yprev == null;
        } else {
            createLeftSegment = y != null && yprev != null;
            leftOpen = false;
            leftClose = createLeftSegment && ynext == null;
            createRightSegment = y != null && ynext != null;
            rightOpen = createRightSegment && yprev == null;
            rightClose = false;
            createIsolatedSegment = y != null && yprev == null && ynext == null;
        }
        double xw = columnAxis.translateToWorld(columnValue, ww) + xOffset;
        double yw = Double.NaN;
        if (y != null) {
            yw = valueAxis.translateToWorld(y.doubleValue(), hh) + yOffset;
        }
        double zw = rowAxis.translateToWorld(rowValue, dd) + zOffset;
        double ywmin = valueAxis.translateToWorld(r.getMin(), hh) + yOffset;
        double ywmax = valueAxis.translateToWorld(r.getMax(), hh) + yOffset;
        double basew = valueAxis.translateToWorld(this.base, hh) + yOffset;
        Color clipColor = color = this.getColorSource().getColor(series, row, column);
        if (this.getClipColorSource() != null && (c = this.getClipColorSource().getColor(series, row, column)) != null) {
            clipColor = c;
        }
        KeyedValues3DItemKey itemKey = new KeyedValues3DItemKey(seriesKey, rowKey, columnKey);
        if (createLeftSegment) {
            Object prevColumnKey = dataset.getColumnKey(column - 1);
            double prevColumnValue = columnAxis.getCategoryValue((Comparable<?>)prevColumnKey);
            double prevColumnX = columnAxis.translateToWorld(prevColumnValue, ww) + xOffset;
            double xl = (prevColumnX + xw) / 2.0;
            assert (yprev != null);
            double yprevw = valueAxis.translateToWorld(yprev.doubleValue(), hh) + yOffset;
            double yl = (yprevw + yw) / 2.0;
            List<Object3D> leftObjs = this.createSegment(xl, yl, xw, yw, zw, basew, ywmin, ywmax, color, this.baseColor, clipColor, leftOpen, leftClose);
            for (Object3D obj : leftObjs) {
                obj.setProperty("key", itemKey);
                obj.setOutline(this.drawFaceOutlines);
                world.add(obj);
            }
        }
        if (createRightSegment) {
            Object nextColumnKey = dataset.getColumnKey(column + 1);
            double nextColumnValue = columnAxis.getCategoryValue((Comparable<?>)nextColumnKey);
            double nextColumnX = columnAxis.translateToWorld(nextColumnValue, ww) + xOffset;
            double xr = (nextColumnX + xw) / 2.0;
            assert (ynext != null);
            double ynextw = valueAxis.translateToWorld(ynext.doubleValue(), hh) + yOffset;
            double yr = (ynextw + yw) / 2.0;
            List<Object3D> rightObjs = this.createSegment(xw, yw, xr, yr, zw, basew, ywmin, ywmax, color, this.baseColor, clipColor, rightOpen, rightClose);
            for (Object3D obj : rightObjs) {
                obj.setProperty("key", itemKey);
                obj.setOutline(this.drawFaceOutlines);
                world.add(obj);
            }
        }
        if (createIsolatedSegment) {
            double cw = columnAxis.getCategoryWidth() * this.isolatedItemWidthPercent;
            double cww = columnAxis.translateToWorld(cw, ww);
            double h = yw - basew;
            Object3D isolated = Object3D.createBox(xw, cww, yw - h / 2.0, h, zw, this.depth, color);
            isolated.setOutline(this.drawFaceOutlines);
            isolated.setProperty("key", itemKey);
            world.add(isolated);
        }
        if (this.getItemLabelGenerator() != null && !Double.isNaN(yw) && yw >= ywmin && yw <= ywmax) {
            String label = this.getItemLabelGenerator().generateItemLabel(dataset, (Comparable<?>)seriesKey, (Comparable<?>)rowKey, (Comparable<?>)columnKey);
            ItemLabelPositioning positioning = this.getItemLabelPositioning();
            Offset3D offsets = this.getItemLabelOffsets();
            double ydelta = dimensions.getHeight() * offsets.getDY();
            if (yw < basew) {
                ydelta = -ydelta;
            }
            if (positioning.equals((Object)ItemLabelPositioning.CENTRAL)) {
                Object3D labelObj = Object3D.createLabelObject(label, this.getItemLabelFont(), this.getItemLabelColor(), this.getItemLabelBackgroundColor(), xw, yw + ydelta, zw, false, true);
                labelObj.setProperty("key", itemKey);
                world.add(labelObj);
            } else if (positioning.equals((Object)ItemLabelPositioning.FRONT_AND_BACK)) {
                double zdelta = this.depth / 2.0 * offsets.getDZ();
                Object3D labelObj1 = Object3D.createLabelObject(label, this.getItemLabelFont(), this.getItemLabelColor(), this.getItemLabelBackgroundColor(), xw, yw + ydelta, zw - zdelta, false, false);
                labelObj1.setProperty("class", "ItemLabel");
                labelObj1.setProperty("key", itemKey);
                world.add(labelObj1);
                Object3D labelObj2 = Object3D.createLabelObject(label, this.getItemLabelFont(), this.getItemLabelColor(), this.getItemLabelBackgroundColor(), xw, yw + ydelta, zw + zdelta, true, false);
                labelObj2.setProperty("class", "ItemLabel");
                labelObj2.setProperty("key", itemKey);
                world.add(labelObj2);
            }
        }
    }

    private List<Object3D> createSegment(double x0, double y0, double x1, double y1, double z, double base, double ymin, double ymax, Color color, Color baseColor, Color clipColor, boolean openingFace, boolean closingFace) {
        ArrayList<Object3D> result = new ArrayList<Object3D>(2);
        if (!this.isBaselineCrossed(y0, y1, base)) {
            Object3D segment = this.createSegmentWithoutCrossing(x0, y0, x1, y1, z, base, ymin, ymax, color, baseColor, clipColor, openingFace, closingFace);
            result.add(segment);
        } else {
            result.addAll(this.createSegmentWithCrossing(x0, y0, x1, y1, z, base, ymin, ymax, color, baseColor, clipColor, openingFace, closingFace));
        }
        return result;
    }

    private boolean isBaselineCrossed(double y0, double y1, double baseline) {
        return y0 > baseline && y1 < baseline || y0 < baseline && y1 > baseline;
    }

    private Object3D createSegmentWithoutCrossing(double x0, double y0, double x1, double y1, double z, double base, double ymin, double ymax, Color color, Color baseColor, Color clipColor, boolean openingFace, boolean closingFace) {
        boolean positive;
        boolean bl = positive = y0 > base || y1 > base;
        if (positive) {
            Object3D pos = this.createPositiveArea(x0, y0, x1, y1, base, z, new Range(ymin, ymax), color, openingFace, closingFace);
            return pos;
        }
        Object3D neg = this.createNegativeArea(x0, y0, x1, y1, base, z, new Range(ymin, ymax), color, openingFace, closingFace);
        return neg;
    }

    private List<Object3D> createSegmentWithCrossing(double x0, double y0, double x1, double y1, double z, double base, double ymin, double ymax, Color color, Color baseColor, Color clipColor, boolean openingFace, boolean closingFace) {
        ArrayList<Object3D> result = new ArrayList<Object3D>(2);
        Range range = new Range(ymin, ymax);
        double ydelta = Math.abs(y1 - y0);
        double factor = 0.0;
        if (ydelta != 0.0) {
            factor = Math.abs(y0 - base) / ydelta;
        }
        double xcross = x0 + factor * (x1 - x0);
        if (y0 > base) {
            Object3D neg;
            Object3D pos = this.createPositiveArea(x0, y0, xcross, base, base, z, range, color, openingFace, closingFace);
            if (pos != null) {
                result.add(pos);
            }
            if ((neg = this.createNegativeArea(xcross, base, x1, y1, base, z, range, color, openingFace, closingFace)) != null) {
                result.add(neg);
            }
        } else {
            Object3D pos;
            Object3D neg = this.createNegativeArea(x0, y0, xcross, base, base, z, range, color, openingFace, closingFace);
            if (neg != null) {
                result.add(neg);
            }
            if ((pos = this.createPositiveArea(xcross, base, x1, y1, base, z, range, color, openingFace, closingFace)) != null) {
                result.add(pos);
            }
        }
        return result;
    }

    private double fraction(double x, double x0, double x1) {
        double dist = x - x0;
        double length = x1 - x0;
        return dist / length;
    }

    private Object3D createPositiveArea(double wx0, double wy0, double wx1, double wy1, double wbase, double wz, Range range, Color color, boolean openingFace, boolean closingFace) {
        int vertices;
        if (!range.intersects(wy0, wbase) && !range.intersects(wy1, wbase)) {
            return null;
        }
        double wy00 = range.peggedValue(wy0);
        double wy11 = range.peggedValue(wy1);
        double wbb = range.peggedValue(wbase);
        double wx00 = wx0;
        if (wy0 < range.getMin()) {
            wx00 = wx0 + (wx1 - wx0) * this.fraction(wy00, wy0, wy1);
        }
        double wx11 = wx1;
        if (wy1 < range.getMin()) {
            wx11 = wx1 - (wx1 - wx0) * this.fraction(wy11, wy1, wy0);
        }
        double wx22 = Double.NaN;
        boolean p2required = Utils2D.spans(range.getMax(), wy0, wy1);
        if (p2required) {
            wx22 = wx0 + (wx1 - wx0) * this.fraction(range.getMax(), wy0, wy1);
        }
        double delta = this.depth / 2.0;
        Object3D obj = new Object3D(color, true);
        obj.addVertex(wx00, wbb, wz - delta);
        obj.addVertex(wx00, wbb, wz + delta);
        boolean leftSide = false;
        if (Math.abs(wy00 - wbb) > 0.001) {
            leftSide = true;
            obj.addVertex(wx00, wy00, wz - delta);
            obj.addVertex(wx00, wy00, wz + delta);
        }
        if (p2required) {
            obj.addVertex(wx22, range.getMax(), wz - delta);
            obj.addVertex(wx22, range.getMax(), wz + delta);
        }
        obj.addVertex(wx11, wy11, wz - delta);
        obj.addVertex(wx11, wy11, wz + delta);
        boolean rightSide = false;
        if (Math.abs(wy11 - wbb) > 0.001) {
            rightSide = true;
            obj.addVertex(wx11, wbb, wz - delta);
            obj.addVertex(wx11, wbb, wz + delta);
        }
        if ((vertices = obj.getVertexCount()) == 10) {
            obj.addFace(new int[]{0, 2, 4, 6, 8});
            obj.addFace(new int[]{1, 9, 7, 5, 3});
            obj.addFace(new int[]{0, 8, 9, 1});
            obj.addFace(new int[]{2, 3, 5, 4});
            obj.addFace(new int[]{4, 5, 7, 6});
            if (openingFace) {
                obj.addFace(new int[]{0, 1, 3, 2});
            }
            if (closingFace) {
                obj.addFace(new int[]{6, 7, 9, 8});
            }
        } else if (vertices == 8) {
            obj.addFace(new int[]{0, 2, 4, 6});
            obj.addFace(new int[]{7, 5, 3, 1});
            if (!leftSide) {
                obj.addFace(new int[]{0, 1, 3, 2});
            }
            obj.addFace(new int[]{2, 3, 5, 4});
            if (!rightSide) {
                obj.addFace(new int[]{4, 5, 7, 6});
            }
            obj.addFace(new int[]{1, 0, 6, 7});
            if (openingFace) {
                obj.addFace(new int[]{0, 1, 3, 2});
            }
            if (closingFace) {
                obj.addFace(new int[]{4, 5, 7, 6});
            }
        } else if (vertices == 6) {
            obj.addFace(new int[]{0, 2, 4});
            obj.addFace(new int[]{5, 3, 1});
            if (leftSide) {
                obj.addFace(new int[]{3, 5, 4, 2});
                if (openingFace) {
                    obj.addFace(new int[]{0, 1, 3, 2});
                }
            } else {
                obj.addFace(new int[]{0, 1, 3, 2});
                if (closingFace) {
                    obj.addFace(new int[]{2, 3, 5, 4});
                }
            }
            obj.addFace(new int[]{0, 4, 5, 1});
        } else {
            obj.addFace(new int[]{0, 1, 3, 2});
            obj.addFace(new int[]{2, 3, 1, 0});
        }
        return obj;
    }

    private Object3D createNegativeArea(double wx0, double wy0, double wx1, double wy1, double wbase, double wz, Range range, Color color, boolean openingFace, boolean closingFace) {
        int vertices;
        if (!range.intersects(wy0, wbase) && !range.intersects(wy1, wbase)) {
            return null;
        }
        double wy00 = range.peggedValue(wy0);
        double wy11 = range.peggedValue(wy1);
        double wbb = range.peggedValue(wbase);
        double wx00 = wx0;
        if (wy0 > range.getMax()) {
            wx00 = wx0 + (wx1 - wx0) * this.fraction(wy00, wy0, wy1);
        }
        double wx11 = wx1;
        if (wy1 > range.getMax()) {
            wx11 = wx1 - (wx1 - wx0) * this.fraction(wy11, wy1, wy0);
        }
        double wx22 = (wx00 + wx11) / 2.0;
        boolean p2required = Utils2D.spans(range.getMin(), wy0, wy1);
        if (p2required) {
            wx22 = wx0 + (wx1 - wx0) * this.fraction(range.getMin(), wy0, wy1);
        }
        double delta = this.depth / 2.0;
        Object3D obj = new Object3D(color, true);
        obj.addVertex(wx00, wbb, wz - delta);
        obj.addVertex(wx00, wbb, wz + delta);
        boolean leftSide = false;
        if (Math.abs(wy00 - wbb) > 0.001) {
            leftSide = true;
            obj.addVertex(wx00, wy00, wz - delta);
            obj.addVertex(wx00, wy00, wz + delta);
        }
        if (p2required) {
            obj.addVertex(wx22, range.getMin(), wz - delta);
            obj.addVertex(wx22, range.getMin(), wz + delta);
        }
        obj.addVertex(wx11, wy11, wz - delta);
        obj.addVertex(wx11, wy11, wz + delta);
        boolean rightSide = false;
        if (Math.abs(wy11 - wbb) > 0.001) {
            obj.addVertex(wx11, wbb, wz - delta);
            obj.addVertex(wx11, wbb, wz + delta);
        }
        if ((vertices = obj.getVertexCount()) == 10) {
            obj.addFace(new int[]{8, 6, 4, 2, 0});
            obj.addFace(new int[]{1, 3, 5, 7, 9});
            obj.addFace(new int[]{1, 9, 8, 0});
            obj.addFace(new int[]{4, 5, 3, 2});
            obj.addFace(new int[]{6, 7, 5, 4});
            if (openingFace) {
                obj.addFace(new int[]{2, 3, 1, 0});
            }
            if (closingFace) {
                obj.addFace(new int[]{8, 9, 7, 6});
            }
        } else if (vertices == 8) {
            obj.addFace(new int[]{2, 0, 6, 4});
            obj.addFace(new int[]{1, 3, 5, 7});
            obj.addFace(new int[]{0, 1, 7, 6});
            if (!leftSide) {
                obj.addFace(new int[]{2, 3, 1, 0});
            }
            obj.addFace(new int[]{3, 2, 4, 5});
            if (!rightSide) {
                obj.addFace(new int[]{6, 7, 5, 4});
            }
            if (openingFace) {
                obj.addFace(new int[]{1, 0, 2, 3});
            }
            if (closingFace) {
                obj.addFace(new int[]{5, 4, 6, 7});
            }
        } else if (vertices == 6) {
            obj.addFace(new int[]{4, 2, 0});
            obj.addFace(new int[]{1, 3, 5});
            if (leftSide) {
                obj.addFace(new int[]{4, 5, 3, 2});
                if (openingFace) {
                    obj.addFace(new int[]{1, 0, 2, 3});
                }
            } else {
                obj.addFace(new int[]{2, 3, 1, 0});
                if (closingFace) {
                    obj.addFace(new int[]{3, 2, 4, 5});
                }
            }
            obj.addFace(new int[]{0, 1, 5, 4});
        } else {
            obj.addFace(new int[]{0, 1, 3, 2});
            obj.addFace(new int[]{2, 3, 1, 0});
        }
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AreaRenderer3D)) {
            return false;
        }
        AreaRenderer3D that = (AreaRenderer3D)obj;
        if (this.base != that.base) {
            return false;
        }
        if (!ObjectUtils.equals(this.baseColor, that.baseColor)) {
            return false;
        }
        if (this.depth != that.depth) {
            return false;
        }
        return super.equals(obj);
    }
}

