/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.category;

import com.orsoncharts.Range;
import com.orsoncharts.axis.CategoryAxis3D;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.KeyedValues3DItemKey;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.Offset3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.label.ItemLabelPositioning;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.AbstractCategoryRenderer3D;
import com.orsoncharts.renderer.category.CategoryColorSource;
import com.orsoncharts.renderer.category.StandardCategoryColorSource;
import com.orsoncharts.util.ObjectUtils;
import java.awt.Color;
import java.io.Serializable;

public class LineRenderer3D
extends AbstractCategoryRenderer3D
implements Serializable {
    private double lineWidth = 0.4;
    private double lineHeight = 0.2;
    private double isolatedItemWidthPercent = 0.25;
    private CategoryColorSource clipColorSource = new StandardCategoryColorSource(Color.RED);

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double width) {
        this.lineWidth = width;
        this.fireChangeEvent(true);
    }

    public double getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(double height) {
        this.lineHeight = height;
        this.fireChangeEvent(true);
    }

    public double getIsolatedItemWidthPercent() {
        return this.isolatedItemWidthPercent;
    }

    public void setIsolatedItemWidthPercent(double percent) {
        this.isolatedItemWidthPercent = percent;
        this.fireChangeEvent(true);
    }

    public CategoryColorSource getClipColorSource() {
        return this.clipColorSource;
    }

    public void setClipColorSource(CategoryColorSource source) {
        this.clipColorSource = source;
        this.fireChangeEvent(true);
    }

    @Override
    public void composeItem(CategoryDataset3D dataset, int series, int row, int column, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        String label;
        double cw;
        double cww;
        Object3D isolated;
        double ynextw;
        double yr;
        Object nextColumnKey;
        double nextColumnValue;
        double nextColumnX;
        double xr;
        Object3D right;
        double yprevw;
        double yl;
        Object prevColumnKey;
        double prevColumnValue;
        double prevColumnX;
        double xl;
        Object3D left;
        Color c;
        Color color;
        boolean createIsolatedSegment;
        boolean createRightSegment;
        boolean createLeftSegment;
        Number y = (Number)dataset.getValue(series, row, column);
        Number yprev = null;
        if (column > 0) {
            yprev = (Number)dataset.getValue(series, row, column - 1);
        }
        Number ynext = null;
        if (column < dataset.getColumnCount() - 1) {
            ynext = (Number)dataset.getValue(series, row, column + 1);
        }
        CategoryPlot3D plot = this.getPlot();
        CategoryAxis3D rowAxis = plot.getRowAxis();
        CategoryAxis3D columnAxis = plot.getColumnAxis();
        ValueAxis3D valueAxis = plot.getValueAxis();
        Range r = valueAxis.getRange();
        Object seriesKey = dataset.getSeriesKey(series);
        Object rowKey = dataset.getRowKey(row);
        Object columnKey = dataset.getColumnKey(column);
        double rowValue = rowAxis.getCategoryValue((Comparable<?>)rowKey);
        double columnValue = columnAxis.getCategoryValue((Comparable<?>)columnKey);
        double ww = dimensions.getWidth();
        double hh = dimensions.getHeight();
        double dd = dimensions.getDepth();
        boolean leftOpen = false;
        boolean leftClose = false;
        boolean rightOpen = false;
        boolean rightClose = false;
        if (column == 0) {
            createLeftSegment = false;
            if (dataset.getColumnCount() == 1) {
                createRightSegment = false;
                createIsolatedSegment = y != null;
            } else {
                createRightSegment = y != null && ynext != null;
                rightOpen = true;
                rightClose = false;
                createIsolatedSegment = y != null && ynext == null;
            }
        } else if (column == dataset.getColumnCount() - 1) {
            createRightSegment = false;
            createLeftSegment = y != null && yprev != null;
            leftOpen = false;
            leftClose = true;
            createIsolatedSegment = y != null && yprev == null;
        } else {
            createLeftSegment = y != null && yprev != null;
            leftOpen = false;
            leftClose = createLeftSegment && ynext == null;
            createRightSegment = y != null && ynext != null;
            rightOpen = createRightSegment && yprev == null;
            rightClose = false;
            createIsolatedSegment = y != null && yprev == null && ynext == null;
        }
        double xw = columnAxis.translateToWorld(columnValue, ww) + xOffset;
        double yw = Double.NaN;
        if (y != null) {
            yw = valueAxis.translateToWorld(y.doubleValue(), hh) + yOffset;
        }
        double zw = rowAxis.translateToWorld(rowValue, dd) + zOffset;
        double ywmin = valueAxis.translateToWorld(r.getMin(), hh) + yOffset;
        double ywmax = valueAxis.translateToWorld(r.getMax(), hh) + yOffset;
        Color clipColor = color = this.getColorSource().getColor(series, row, column);
        if (this.getClipColorSource() != null && (c = this.getClipColorSource().getColor(series, row, column)) != null) {
            clipColor = c;
        }
        KeyedValues3DItemKey itemKey = new KeyedValues3DItemKey(seriesKey, rowKey, columnKey);
        if (createLeftSegment && (left = this.createSegment(xl = ((prevColumnX = columnAxis.translateToWorld(prevColumnValue = columnAxis.getCategoryValue((Comparable<?>)(prevColumnKey = dataset.getColumnKey(column - 1))), ww) + xOffset) + xw) / 2.0, yl = ((yprevw = valueAxis.translateToWorld(yprev.doubleValue(), hh) + yOffset) + yw) / 2.0, xw, yw, zw, this.lineWidth, this.lineHeight, ywmin, ywmax, color, clipColor, leftOpen, leftClose)) != null) {
            left.setProperty("key", itemKey);
            world.add(left);
        }
        if (createRightSegment && (right = this.createSegment(xw, yw, xr = ((nextColumnX = columnAxis.translateToWorld(nextColumnValue = columnAxis.getCategoryValue((Comparable<?>)(nextColumnKey = dataset.getColumnKey(column + 1))), ww) + xOffset) + xw) / 2.0, yr = ((ynextw = valueAxis.translateToWorld(ynext.doubleValue(), hh) + yOffset) + yw) / 2.0, zw, this.lineWidth, this.lineHeight, ywmin, ywmax, color, clipColor, rightOpen, rightClose)) != null) {
            right.setProperty("key", itemKey);
            world.add(right);
        }
        if (createIsolatedSegment && (isolated = Object3D.createBox(xw, cww = columnAxis.translateToWorld(cw = columnAxis.getCategoryWidth() * this.isolatedItemWidthPercent, ww), yw, this.lineHeight, zw, this.lineWidth, color)) != null) {
            isolated.setProperty("key", itemKey);
            world.add(isolated);
        }
        if (this.getItemLabelGenerator() != null && !Double.isNaN(yw) && yw >= ywmin && yw <= ywmax && (label = this.getItemLabelGenerator().generateItemLabel(dataset, (Comparable<?>)seriesKey, (Comparable<?>)rowKey, (Comparable<?>)columnKey)) != null) {
            ItemLabelPositioning positioning = this.getItemLabelPositioning();
            Offset3D offsets = this.getItemLabelOffsets();
            double dy = offsets.getDY() * dimensions.getHeight();
            if (positioning.equals((Object)ItemLabelPositioning.CENTRAL)) {
                Object3D labelObj = Object3D.createLabelObject(label, this.getItemLabelFont(), this.getItemLabelColor(), this.getItemLabelBackgroundColor(), xw, yw + dy, zw, false, true);
                labelObj.setProperty("key", itemKey);
                world.add(labelObj);
            } else if (positioning.equals((Object)ItemLabelPositioning.FRONT_AND_BACK)) {
                double dz = this.lineWidth;
                Object3D labelObj1 = Object3D.createLabelObject(label, this.getItemLabelFont(), this.getItemLabelColor(), this.getItemLabelBackgroundColor(), xw, yw, zw - dz, false, false);
                labelObj1.setProperty("key", itemKey);
                world.add(labelObj1);
                Object3D labelObj2 = Object3D.createLabelObject(label, this.getItemLabelFont(), this.getItemLabelColor(), this.getItemLabelBackgroundColor(), xw, yw, zw + dz, true, false);
                labelObj2.setProperty("key", itemKey);
                world.add(labelObj2);
            }
        }
    }

    private Object3D createSegment(double x0, double y0, double x1, double y1, double z, double lineWidth, double lineHeight, double ymin, double ymax, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        double wdelta = lineWidth / 2.0;
        double hdelta = lineHeight / 2.0;
        double y0b = y0 - hdelta;
        double y0t = y0 + hdelta;
        double y1b = y1 - hdelta;
        double y1t = y1 + hdelta;
        double zf = z - wdelta;
        double zb = z + wdelta;
        double[] xpts = this.calcCrossPoints(x0, x1, y0b, y0t, y1b, y1t, ymin, ymax);
        Object3D seg = null;
        if (y0b >= ymax) {
            seg = this.createSegmentA(x0, x1, xpts, y0b, y0t, y1b, y1t, ymin, ymax, zf, zb, color, clipColor, false, closingFace);
        } else if (y0t > ymax && y0b > ymin) {
            seg = this.createSegmentB(x0, x1, xpts, y0b, y0t, y1b, y1t, ymin, ymax, zf, zb, color, clipColor, openingFace, closingFace);
        } else if (y0t > ymax && y0b <= ymin) {
            seg = this.createSegmentC(x0, x1, xpts, y0b, y0t, y1b, y1t, ymin, ymax, zf, zb, color, clipColor, openingFace, closingFace);
        } else if (y0t > ymin && y0b >= ymin) {
            seg = this.createSegmentD(x0, x1, xpts, y0b, y0t, y1b, y1t, ymin, ymax, zf, zb, color, clipColor, openingFace, closingFace);
        } else if (y0t > ymin && y0b < ymin) {
            seg = this.createSegmentE(x0, x1, xpts, y0b, y0t, y1b, y1t, ymin, ymax, zf, zb, color, clipColor, openingFace, closingFace);
        } else if (y0t <= ymin) {
            seg = this.createSegmentF(x0, x1, xpts, y0b, y0t, y1b, y1t, ymin, ymax, zf, zb, color, clipColor, false, closingFace);
        }
        return seg;
    }

    private double[] calcCrossPoints(double x0, double x1, double y0b, double y0t, double y1b, double y1t, double ymin, double ymax) {
        double[] xpts = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        double factor = (y0b - ymin) / (y0b - y1b);
        xpts[0] = x0 + factor * (x1 - x0);
        factor = (y0t - ymin) / (y0t - y1t);
        xpts[1] = x0 + factor * (x1 - x0);
        factor = (y0b - ymax) / (y0b - y1b);
        xpts[2] = x0 + factor * (x1 - x0);
        factor = (y0t - ymax) / (y0t - y1t);
        xpts[3] = x0 + factor * (x1 - x0);
        return xpts;
    }

    private Object3D createSegmentA(double x0, double x1, double[] xpts, double y0b, double y0t, double y1b, double y1t, double wmin, double wmax, double zf, double zb, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        if (y1b > wmax) {
            return null;
        }
        if (y1t > wmax) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D(color, true);
                seg.setProperty("color/clip", clipColor);
                seg.addVertex(xpts[2], wmax, zf);
                seg.addVertex(xpts[2], wmax, zb);
                seg.addVertex(x1, wmax, zf);
                seg.addVertex(x1, wmax, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addFace(new int[]{0, 2, 4});
                seg.addFace(new int[]{1, 5, 3});
                seg.addFace(new int[]{0, 1, 3, 2}, "clip");
                seg.addFace(new int[]{4, 5, 1, 0});
                if (closingFace) {
                    seg.addFace(new int[]{2, 3, 5, 4});
                }
                return seg;
            }
            Object3D seg = new Object3D(color, true);
            seg.setProperty("color/clip", clipColor);
            seg.addVertex(xpts[2], wmax, zf);
            seg.addVertex(xpts[2], wmax, zb);
            seg.addVertex(x1, wmax, zf);
            seg.addVertex(x1, wmax, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6});
            seg.addFace(new int[]{1, 7, 5, 3});
            seg.addFace(new int[]{0, 1, 3, 2});
            seg.addFace(new int[]{4, 5, 7, 6}, "clip");
            seg.addFace(new int[]{6, 7, 1, 0});
            if (closingFace) {
                seg.addFace(new int[]{2, 3, 5, 4});
            }
            return seg;
        }
        if (y1t >= wmin) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D(color, true);
                seg.setProperty("color/clip", clipColor);
                seg.addVertex(xpts[2], wmax, zf);
                seg.addVertex(xpts[2], wmax, zb);
                seg.addVertex(xpts[3], wmax, zf);
                seg.addVertex(xpts[3], wmax, zb);
                seg.addVertex(x1, y1t, zf);
                seg.addVertex(x1, y1t, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addFace(new int[]{0, 2, 4, 6});
                seg.addFace(new int[]{1, 7, 5, 3});
                seg.addFace(new int[]{0, 1, 3, 2}, "clip");
                seg.addFace(new int[]{2, 3, 5, 4});
                seg.addFace(new int[]{6, 7, 1, 0});
                if (closingFace) {
                    seg.addFace(new int[]{4, 5, 7, 6});
                }
                return seg;
            }
            Object3D seg = new Object3D(color, true);
            seg.setProperty("color/clip", clipColor);
            seg.addVertex(xpts[2], wmax, zf);
            seg.addVertex(xpts[2], wmax, zb);
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(x1, y1t, zf);
            seg.addVertex(x1, y1t, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6, 8});
            seg.addFace(new int[]{1, 9, 7, 5, 3});
            seg.addFace(new int[]{2, 3, 5, 4});
            seg.addFace(new int[]{0, 1, 3, 2}, "clip");
            seg.addFace(new int[]{6, 7, 9, 8}, "clip");
            seg.addFace(new int[]{8, 9, 1, 0});
            if (closingFace) {
                seg.addFace(new int[]{4, 5, 7, 6});
            }
            return seg;
        }
        Object3D seg = new Object3D(color, true);
        seg.setProperty("color/clip", clipColor);
        seg.addVertex(xpts[2], wmax, zf);
        seg.addVertex(xpts[2], wmax, zb);
        seg.addVertex(xpts[3], wmax, zf);
        seg.addVertex(xpts[3], wmax, zb);
        seg.addVertex(xpts[1], wmin, zf);
        seg.addVertex(xpts[1], wmin, zb);
        seg.addVertex(xpts[0], wmin, zf);
        seg.addVertex(xpts[0], wmin, zb);
        seg.addFace(new int[]{0, 2, 4, 6});
        seg.addFace(new int[]{1, 7, 5, 3});
        seg.addFace(new int[]{4, 2, 3, 5});
        seg.addFace(new int[]{0, 6, 7, 1});
        seg.addFace(new int[]{0, 1, 3, 2}, "clip");
        seg.addFace(new int[]{4, 5, 7, 6}, "clip");
        return seg;
    }

    private Object3D createSegmentB(double x0, double x1, double[] xpts, double y0b, double y0t, double y1b, double y1t, double wmin, double wmax, double zf, double zb, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        if (y1b >= wmax) {
            Object3D seg = new Object3D(color, true);
            seg.setProperty("color/clip", clipColor);
            seg.addVertex(x0, y0b, zf);
            seg.addVertex(x0, y0b, zb);
            seg.addVertex(x0, wmax, zf);
            seg.addVertex(x0, wmax, zb);
            seg.addVertex(xpts[2], wmax, zf);
            seg.addVertex(xpts[2], wmax, zb);
            seg.addFace(new int[]{0, 2, 4});
            seg.addFace(new int[]{1, 5, 3});
            seg.addFace(new int[]{0, 4, 5, 1});
            seg.addFace(new int[]{2, 3, 5, 4}, "clip");
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2});
            }
            return seg;
        }
        if (y1t > wmax) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D(color, true);
                seg.setProperty("color/clip", clipColor);
                seg.addVertex(x0, y0b, zf);
                seg.addVertex(x0, y0b, zb);
                seg.addVertex(x0, wmax, zf);
                seg.addVertex(x0, wmax, zb);
                seg.addVertex(x1, wmax, zf);
                seg.addVertex(x1, wmax, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addFace(new int[]{0, 2, 4, 6});
                seg.addFace(new int[]{1, 7, 5, 3});
                seg.addFace(new int[]{2, 3, 5, 4}, "clip");
                seg.addFace(new int[]{0, 6, 7, 1});
                if (openingFace) {
                    seg.addFace(new int[]{0, 1, 3, 2});
                }
                if (closingFace) {
                    seg.addFace(new int[]{4, 5, 7, 6});
                }
                return seg;
            }
            Object3D seg = new Object3D(color, true);
            seg.setProperty("color/clip", clipColor);
            seg.addVertex(x0, y0b, zf);
            seg.addVertex(x0, y0b, zb);
            seg.addVertex(x0, wmax, zf);
            seg.addVertex(x0, wmax, zb);
            seg.addVertex(x1, wmax, zf);
            seg.addVertex(x1, wmax, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6, 8});
            seg.addFace(new int[]{1, 9, 7, 5, 3});
            seg.addFace(new int[]{2, 3, 5, 4}, "clip");
            seg.addFace(new int[]{8, 6, 7, 9}, "clip");
            seg.addFace(new int[]{0, 8, 9, 1});
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2});
            }
            if (closingFace) {
                seg.addFace(new int[]{4, 5, 7, 6});
            }
            return seg;
        }
        if (y1t > wmin) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D(color, true);
                seg.setProperty("color/clip", clipColor);
                seg.addVertex(x0, y0b, zf);
                seg.addVertex(x0, y0b, zb);
                seg.addVertex(x0, wmax, zf);
                seg.addVertex(x0, wmax, zb);
                seg.addVertex(xpts[3], wmax, zf);
                seg.addVertex(xpts[3], wmax, zb);
                seg.addVertex(x1, y1t, zf);
                seg.addVertex(x1, y1t, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addFace(new int[]{0, 2, 4, 6, 8});
                seg.addFace(new int[]{1, 9, 7, 5, 3});
                seg.addFace(new int[]{2, 3, 5, 4}, "clip");
                seg.addFace(new int[]{4, 5, 7, 6});
                seg.addFace(new int[]{0, 8, 9, 1});
                if (openingFace) {
                    seg.addFace(new int[]{0, 1, 3, 2});
                }
                if (closingFace) {
                    seg.addFace(new int[]{6, 7, 9, 8});
                }
                return seg;
            }
            Object3D seg = new Object3D(color, true);
            seg.setProperty("color/clip", clipColor);
            seg.addVertex(x0, y0b, zf);
            seg.addVertex(x0, y0b, zb);
            seg.addVertex(x0, wmax, zf);
            seg.addVertex(x0, wmax, zb);
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(x1, y1t, zf);
            seg.addVertex(x1, y1t, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6, 8, 10});
            seg.addFace(new int[]{1, 11, 9, 7, 5, 3});
            seg.addFace(new int[]{2, 3, 5, 4}, "clip");
            seg.addFace(new int[]{4, 5, 7, 6});
            seg.addFace(new int[]{8, 9, 11, 10}, "clip");
            seg.addFace(new int[]{10, 11, 1, 0});
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2});
            }
            if (closingFace) {
                seg.addFace(new int[]{6, 7, 9, 8});
            }
            return seg;
        }
        Object3D seg = new Object3D(color, true);
        seg.setProperty("color/clip", clipColor);
        seg.addVertex(x0, y0b, zf);
        seg.addVertex(x0, y0b, zb);
        seg.addVertex(x0, wmax, zf);
        seg.addVertex(x0, wmax, zb);
        seg.addVertex(xpts[3], wmax, zf);
        seg.addVertex(xpts[3], wmax, zb);
        seg.addVertex(xpts[1], wmin, zf);
        seg.addVertex(xpts[1], wmin, zb);
        seg.addVertex(xpts[0], wmin, zf);
        seg.addVertex(xpts[0], wmin, zb);
        seg.addFace(new int[]{0, 2, 4, 6, 8});
        seg.addFace(new int[]{1, 9, 7, 5, 3});
        seg.addFace(new int[]{2, 3, 5, 4}, "clip");
        seg.addFace(new int[]{4, 5, 7, 6});
        seg.addFace(new int[]{6, 7, 9, 8}, "clip");
        seg.addFace(new int[]{8, 9, 1, 0});
        if (openingFace) {
            seg.addFace(new int[]{0, 1, 3, 2});
        }
        return seg;
    }

    private Object3D createSegmentC(double x0, double x1, double[] xpts, double y0b, double y0t, double y1b, double y1t, double wmin, double wmax, double zf, double zb, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        Object3D seg = new Object3D(color, true);
        seg.setProperty("color/clip", clipColor);
        seg.addVertex(x0, wmin, zf);
        seg.addVertex(x0, wmin, zb);
        seg.addVertex(x0, wmax, zf);
        seg.addVertex(x0, wmax, zb);
        if (openingFace) {
            seg.addFace(new int[]{0, 1, 3, 2});
        }
        if (y1b >= wmax) {
            seg.addVertex(xpts[2], wmax, zf);
            seg.addVertex(xpts[2], wmax, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6});
            seg.addFace(new int[]{1, 7, 5, 3});
            seg.addFace(new int[]{2, 3, 5, 4}, "clip");
            seg.addFace(new int[]{4, 5, 7, 6});
            seg.addFace(new int[]{7, 1, 0, 6}, "clip");
            return seg;
        }
        if (y1t > wmax) {
            if (y1b >= wmin) {
                seg.addVertex(x1, wmax, zf);
                seg.addVertex(x1, wmax, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addVertex(xpts[0], wmin, zf);
                seg.addVertex(xpts[0], wmin, zb);
                seg.addFace(new int[]{0, 2, 4, 6, 8});
                seg.addFace(new int[]{1, 9, 7, 5, 3});
                seg.addFace(new int[]{2, 3, 5, 4}, "clip");
                seg.addFace(new int[]{6, 7, 9, 8});
                seg.addFace(new int[]{8, 9, 1, 0}, "clip");
                if (closingFace) {
                    seg.addFace(new int[]{4, 5, 7, 6});
                }
                return seg;
            }
            seg.addVertex(x1, wmax, zf);
            seg.addVertex(x1, wmax, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6});
            seg.addFace(new int[]{1, 7, 5, 3});
            seg.addFace(new int[]{2, 3, 5, 4}, "clip");
            seg.addFace(new int[]{4, 5, 7, 6});
            seg.addFace(new int[]{7, 1, 0, 6}, "clip");
            return seg;
        }
        if (y1t > wmin) {
            if (y1b >= wmin) {
                return null;
            }
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(x1, y1t, zf);
            seg.addVertex(x1, y1t, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6, 8});
            seg.addFace(new int[]{1, 9, 7, 5, 3});
            seg.addFace(new int[]{2, 3, 5, 4}, "clip");
            seg.addFace(new int[]{4, 5, 7, 6});
            seg.addFace(new int[]{9, 1, 0, 8}, "clip");
            if (closingFace) {
                seg.addFace(new int[]{6, 7, 9, 8});
            }
            return seg;
        }
        seg.addVertex(xpts[3], wmax, zf);
        seg.addVertex(xpts[3], wmax, zb);
        seg.addVertex(xpts[1], wmin, zf);
        seg.addVertex(xpts[1], wmin, zb);
        seg.addFace(new int[]{0, 2, 4, 6});
        seg.addFace(new int[]{1, 7, 5, 3});
        seg.addFace(new int[]{2, 3, 5, 4}, "clip");
        seg.addFace(new int[]{4, 5, 7, 6});
        seg.addFace(new int[]{6, 7, 1, 0}, "clip");
        return seg;
    }

    private Object3D createSegmentD(double x0, double x1, double[] xpts, double y0b, double y0t, double y1b, double y1t, double wmin, double wmax, double zf, double zb, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        Object3D seg = new Object3D(color, true);
        seg.setProperty("color/clip", clipColor);
        seg.addVertex(x0, y0b, zf);
        seg.addVertex(x0, y0b, zb);
        seg.addVertex(x0, y0t, zf);
        seg.addVertex(x0, y0t, zb);
        if (y1b >= wmax) {
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(xpts[2], wmax, zf);
            seg.addVertex(xpts[2], wmax, zb);
            seg.addFace(new int[]{0, 2, 4, 6});
            seg.addFace(new int[]{1, 7, 5, 3});
            seg.addFace(new int[]{2, 3, 5, 4});
            seg.addFace(new int[]{4, 5, 7, 6}, "clip");
            seg.addFace(new int[]{0, 6, 7, 1});
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2});
            }
            return seg;
        }
        if (y1t > wmax) {
            if (y1b >= wmin) {
                seg.addVertex(xpts[3], wmax, zf);
                seg.addVertex(xpts[3], wmax, zb);
                seg.addVertex(x1, wmax, zf);
                seg.addVertex(x1, wmax, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addFace(new int[]{0, 2, 4, 6, 8});
                seg.addFace(new int[]{1, 9, 7, 5, 3});
                seg.addFace(new int[]{2, 3, 5, 4});
                seg.addFace(new int[]{4, 5, 7, 6}, "clip");
                seg.addFace(new int[]{0, 8, 9, 1});
                if (openingFace) {
                    seg.addFace(new int[]{0, 1, 3, 2});
                }
                if (closingFace) {
                    seg.addFace(new int[]{6, 7, 9, 8});
                }
                return seg;
            }
            return null;
        }
        if (y1t > wmin) {
            if (y1b >= wmin) {
                seg.addVertex(x1, y1t, zf);
                seg.addVertex(x1, y1t, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addFace(new int[]{0, 2, 4, 6});
                seg.addFace(new int[]{1, 7, 5, 3});
                seg.addFace(new int[]{2, 3, 5, 4});
                seg.addFace(new int[]{0, 6, 7, 1});
                if (openingFace) {
                    seg.addFace(new int[]{0, 1, 3, 2});
                }
                if (closingFace) {
                    seg.addFace(new int[]{4, 5, 7, 6});
                }
                return seg;
            }
            seg.addVertex(x1, y1t, zf);
            seg.addVertex(x1, y1t, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6, 8});
            seg.addFace(new int[]{1, 9, 7, 5, 3});
            seg.addFace(new int[]{2, 3, 5, 4});
            seg.addFace(new int[]{0, 8, 9, 1});
            seg.addFace(new int[]{6, 7, 9, 8}, "clip");
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2});
            }
            if (closingFace) {
                seg.addFace(new int[]{4, 5, 7, 6});
            }
            return seg;
        }
        seg.addVertex(xpts[1], wmin, zf);
        seg.addVertex(xpts[1], wmin, zb);
        seg.addVertex(xpts[0], wmin, zf);
        seg.addVertex(xpts[0], wmin, zb);
        seg.addFace(new int[]{0, 2, 4, 6});
        seg.addFace(new int[]{1, 7, 5, 3});
        seg.addFace(new int[]{2, 3, 5, 4});
        seg.addFace(new int[]{0, 6, 7, 1});
        seg.addFace(new int[]{4, 5, 7, 6}, "clip");
        if (openingFace) {
            seg.addFace(new int[]{0, 1, 3, 2});
        }
        return seg;
    }

    private Object3D createSegmentE(double x0, double x1, double[] xpts, double y0b, double y0t, double y1b, double y1t, double wmin, double wmax, double zf, double zb, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        if (y1b > wmax) {
            Object3D seg = new Object3D(color, true);
            seg.setProperty("color/clip", clipColor);
            seg.addVertex(x0, wmin, zf);
            seg.addVertex(x0, wmin, zb);
            seg.addVertex(x0, y0t, zf);
            seg.addVertex(x0, y0t, zb);
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(xpts[2], wmax, zf);
            seg.addVertex(xpts[2], wmax, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6, 8});
            seg.addFace(new int[]{1, 9, 7, 5, 3});
            seg.addFace(new int[]{2, 3, 5, 4});
            seg.addFace(new int[]{4, 5, 7, 6}, "clip");
            seg.addFace(new int[]{6, 7, 9, 8});
            seg.addFace(new int[]{0, 8, 9, 1}, "clip");
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2});
            }
            return seg;
        }
        if (y1t > wmax) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D(color, true);
                seg.setProperty("color/clip", clipColor);
                seg.addVertex(x0, wmin, zf);
                seg.addVertex(x0, wmin, zb);
                seg.addVertex(x0, y0t, zf);
                seg.addVertex(x0, y0t, zb);
                seg.addVertex(xpts[3], wmax, zf);
                seg.addVertex(xpts[3], wmax, zb);
                seg.addVertex(x1, wmax, zf);
                seg.addVertex(x1, wmax, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addVertex(xpts[0], wmin, zf);
                seg.addVertex(xpts[0], wmin, zb);
                seg.addFace(new int[]{0, 2, 4, 6, 8, 10});
                seg.addFace(new int[]{1, 11, 9, 7, 5, 3});
                seg.addFace(new int[]{2, 3, 5, 4});
                seg.addFace(new int[]{5, 7, 6, 4}, "clip");
                seg.addFace(new int[]{8, 9, 11, 10});
                seg.addFace(new int[]{1, 0, 10, 11}, "clip");
                if (openingFace) {
                    seg.addFace(new int[]{0, 1, 3, 2});
                }
                if (closingFace) {
                    seg.addFace(new int[]{6, 7, 9, 8});
                }
                return seg;
            }
            Object3D seg = new Object3D(color, true);
            seg.setProperty("color/clip", clipColor);
            seg.addVertex(x0, wmin, zf);
            seg.addVertex(x0, wmin, zb);
            seg.addVertex(x0, y0t, zf);
            seg.addVertex(x0, y0t, zb);
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(x1, wmax, zf);
            seg.addVertex(x1, wmax, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6, 8});
            seg.addFace(new int[]{1, 9, 7, 5, 3});
            seg.addFace(new int[]{2, 3, 5, 4});
            seg.addFace(new int[]{5, 7, 6, 4}, "clip");
            seg.addFace(new int[]{0, 8, 9, 1}, "clip");
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2});
            }
            if (closingFace) {
                seg.addFace(new int[]{6, 7, 9, 8});
            }
            return seg;
        }
        if (y1t > wmin) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D(color, true);
                seg.setProperty("color/clip", clipColor);
                seg.addVertex(x0, wmin, zf);
                seg.addVertex(x0, wmin, zb);
                seg.addVertex(x0, y0t, zf);
                seg.addVertex(x0, y0t, zb);
                seg.addVertex(x1, y1t, zf);
                seg.addVertex(x1, y1t, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addVertex(xpts[0], wmin, zf);
                seg.addVertex(xpts[0], wmin, zb);
                seg.addFace(new int[]{0, 2, 4, 6, 8});
                seg.addFace(new int[]{1, 9, 7, 5, 3});
                seg.addFace(new int[]{2, 3, 5, 4});
                seg.addFace(new int[]{6, 7, 9, 8});
                seg.addFace(new int[]{0, 8, 9, 1}, "clip");
                if (openingFace) {
                    seg.addFace(new int[]{0, 1, 3, 2});
                }
                if (closingFace) {
                    seg.addFace(new int[]{4, 5, 7, 6});
                }
                return seg;
            }
            Object3D seg = new Object3D(color, true);
            seg.setProperty("color/clip", clipColor);
            seg.addVertex(x0, wmin, zf);
            seg.addVertex(x0, wmin, zb);
            seg.addVertex(x0, y0t, zf);
            seg.addVertex(x0, y0t, zb);
            seg.addVertex(x1, y1t, zf);
            seg.addVertex(x1, y1t, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6});
            seg.addFace(new int[]{1, 7, 5, 3});
            seg.addFace(new int[]{2, 3, 5, 4});
            seg.addFace(new int[]{0, 6, 7, 1}, "clip");
            if (openingFace) {
                seg.addFace(new int[]{0, 1, 3, 2});
            }
            if (closingFace) {
                seg.addFace(new int[]{4, 5, 7, 6});
            }
            return seg;
        }
        Object3D seg = new Object3D(color, true);
        seg.setProperty("color/clip", clipColor);
        seg.addVertex(x0, wmin, zf);
        seg.addVertex(x0, wmin, zb);
        seg.addVertex(x0, y0t, zf);
        seg.addVertex(x0, y0t, zb);
        seg.addVertex(xpts[1], wmin, zf);
        seg.addVertex(xpts[1], wmin, zb);
        seg.addFace(new int[]{0, 2, 4});
        seg.addFace(new int[]{1, 5, 3});
        seg.addFace(new int[]{2, 3, 5, 4});
        seg.addFace(new int[]{0, 4, 5, 1}, "clip");
        if (openingFace) {
            seg.addFace(new int[]{0, 1, 3, 2});
        }
        return seg;
    }

    private Object3D createSegmentF(double x0, double x1, double[] xpts, double y0b, double y0t, double y1b, double y1t, double wmin, double wmax, double zf, double zb, Color color, Color clipColor, boolean openingFace, boolean closingFace) {
        if (y1b > wmax) {
            Object3D seg = new Object3D(color, true);
            seg.setProperty("color/clip", clipColor);
            seg.addVertex(xpts[1], wmin, zf);
            seg.addVertex(xpts[1], wmin, zb);
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(xpts[2], wmax, zf);
            seg.addVertex(xpts[2], wmax, zb);
            seg.addVertex(xpts[0], wmin, zf);
            seg.addVertex(xpts[0], wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6});
            seg.addFace(new int[]{1, 7, 5, 3});
            seg.addFace(new int[]{0, 1, 3, 2});
            seg.addFace(new int[]{2, 3, 5, 4}, "clip");
            seg.addFace(new int[]{4, 5, 7, 6});
            seg.addFace(new int[]{0, 6, 7, 1}, "clip");
            return seg;
        }
        if (y1t > wmax) {
            if (y1b > wmin) {
                Object3D seg = new Object3D(color, true);
                seg.setProperty("color/clip", clipColor);
                seg.addVertex(xpts[1], wmin, zf);
                seg.addVertex(xpts[1], wmin, zb);
                seg.addVertex(xpts[3], wmax, zf);
                seg.addVertex(xpts[3], wmax, zb);
                seg.addVertex(x1, wmax, zf);
                seg.addVertex(x1, wmax, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addVertex(xpts[0], wmin, zf);
                seg.addVertex(xpts[0], wmin, zb);
                seg.addFace(new int[]{0, 2, 4, 6, 8});
                seg.addFace(new int[]{1, 9, 7, 5, 3});
                seg.addFace(new int[]{2, 3, 5, 4});
                seg.addFace(new int[]{0, 1, 3, 2});
                seg.addFace(new int[]{0, 8, 9, 1}, "clip");
                seg.addFace(new int[]{6, 7, 9, 8});
                if (closingFace) {
                    seg.addFace(new int[]{4, 5, 7, 6});
                }
                return seg;
            }
            Object3D seg = new Object3D(color, true);
            seg.setProperty("color/clip", clipColor);
            seg.addVertex(xpts[1], wmin, zf);
            seg.addVertex(xpts[1], wmin, zb);
            seg.addVertex(xpts[3], wmax, zf);
            seg.addVertex(xpts[3], wmax, zb);
            seg.addVertex(x1, wmax, zf);
            seg.addVertex(x1, wmax, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addFace(new int[]{0, 2, 4, 6});
            seg.addFace(new int[]{1, 7, 5, 3});
            seg.addFace(new int[]{0, 1, 3, 2});
            seg.addFace(new int[]{2, 3, 5, 4}, "clip");
            seg.addFace(new int[]{6, 7, 1, 0}, "clip");
            if (closingFace) {
                seg.addFace(new int[]{4, 5, 7, 6});
            }
            return seg;
        }
        if (y1t > wmin) {
            if (y1b >= wmin) {
                Object3D seg = new Object3D(color, true);
                seg.setProperty("color/clip", clipColor);
                seg.addVertex(xpts[1], wmin, zf);
                seg.addVertex(xpts[1], wmin, zb);
                seg.addVertex(x1, y1t, zf);
                seg.addVertex(x1, y1t, zb);
                seg.addVertex(x1, y1b, zf);
                seg.addVertex(x1, y1b, zb);
                seg.addVertex(xpts[0], wmin, zf);
                seg.addVertex(xpts[0], wmin, zb);
                seg.addFace(new int[]{0, 2, 4, 6});
                seg.addFace(new int[]{1, 7, 5, 3});
                seg.addFace(new int[]{0, 1, 3, 2});
                seg.addFace(new int[]{4, 5, 7, 6});
                seg.addFace(new int[]{0, 6, 7, 1}, "clip");
                if (closingFace) {
                    seg.addFace(new int[]{2, 3, 5, 4});
                }
                return seg;
            }
            Object3D seg = new Object3D(color, true);
            seg.setProperty("color/clip", clipColor);
            seg.addVertex(xpts[1], wmin, zf);
            seg.addVertex(xpts[1], wmin, zb);
            seg.addVertex(x1, y1t, zf);
            seg.addVertex(x1, y1t, zb);
            seg.addVertex(x1, wmin, zf);
            seg.addVertex(x1, wmin, zb);
            seg.addFace(new int[]{0, 2, 4});
            seg.addFace(new int[]{1, 5, 3});
            seg.addFace(new int[]{0, 1, 3, 2});
            seg.addFace(new int[]{0, 4, 5, 1}, "clip");
            if (closingFace) {
                seg.addFace(new int[]{2, 3, 5, 4});
            }
            return seg;
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LineRenderer3D)) {
            return false;
        }
        LineRenderer3D that = (LineRenderer3D)obj;
        if (this.lineWidth != that.lineWidth) {
            return false;
        }
        if (this.lineHeight != that.lineHeight) {
            return false;
        }
        if (this.isolatedItemWidthPercent != that.isolatedItemWidthPercent) {
            return false;
        }
        if (!ObjectUtils.equals(this.clipColorSource, that.clipColorSource)) {
            return false;
        }
        return super.equals(obj);
    }
}

