/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.xyz;

import com.orsoncharts.Range;
import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.label.XYZItemLabelGenerator;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.AbstractRenderer3D;
import com.orsoncharts.renderer.ComposeType;
import com.orsoncharts.renderer.xyz.StandardXYZColorSource;
import com.orsoncharts.renderer.xyz.XYZColorSource;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import java.awt.Color;

public class AbstractXYZRenderer
extends AbstractRenderer3D {
    private XYZPlot plot;
    private XYZColorSource colorSource = new StandardXYZColorSource();
    private XYZItemLabelGenerator itemLabelGenerator = null;

    protected AbstractXYZRenderer() {
    }

    public XYZPlot getPlot() {
        return this.plot;
    }

    public void setPlot(XYZPlot plot) {
        this.plot = plot;
    }

    public XYZItemLabelGenerator getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public void setItemLabelGenerator(XYZItemLabelGenerator generator) {
        this.itemLabelGenerator = generator;
    }

    public ComposeType getComposeType() {
        return ComposeType.PER_ITEM;
    }

    public void composeAll(XYZPlot plot, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        throw new UnsupportedOperationException();
    }

    public XYZColorSource getColorSource() {
        return this.colorSource;
    }

    public void setColorSource(XYZColorSource colorSource) {
        ArgChecks.nullNotPermitted(colorSource, "colorSource");
        this.colorSource = colorSource;
        this.fireChangeEvent(true);
    }

    public void setColors(Color ... colors) {
        this.setColorSource(new StandardXYZColorSource(colors));
    }

    public Range findXRange(XYZDataset dataset) {
        return DataUtils.findXRange(dataset);
    }

    public Range findYRange(XYZDataset dataset) {
        return DataUtils.findYRange(dataset);
    }

    public Range findZRange(XYZDataset dataset) {
        return DataUtils.findZRange(dataset);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractXYZRenderer)) {
            return false;
        }
        AbstractXYZRenderer that = (AbstractXYZRenderer)obj;
        if (!this.colorSource.equals(that.colorSource)) {
            return false;
        }
        if (!ObjectUtils.equals(this.itemLabelGenerator, that.itemLabelGenerator)) {
            return false;
        }
        return super.equals(obj);
    }
}

