/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.xyz;

import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Line3D;
import com.orsoncharts.graphics3d.LineObject3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.xyz.AbstractXYZRenderer;
import com.orsoncharts.renderer.xyz.XYZRenderer;
import java.awt.Color;
import java.io.Serializable;

public class LineXYZRenderer
extends AbstractXYZRenderer
implements XYZRenderer,
Serializable {
    @Override
    public void composeItem(XYZDataset dataset, int series, int item, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        if (item == 0) {
            return;
        }
        XYZPlot plot = this.getPlot();
        ValueAxis3D xAxis = plot.getXAxis();
        ValueAxis3D yAxis = plot.getYAxis();
        ValueAxis3D zAxis = plot.getZAxis();
        double x1 = dataset.getX(series, item);
        double y1 = dataset.getY(series, item);
        double z1 = dataset.getZ(series, item);
        double x0 = dataset.getX(series, item - 1);
        double y0 = dataset.getY(series, item - 1);
        double z0 = dataset.getZ(series, item - 1);
        double wx0 = xAxis.translateToWorld(x0, dimensions.getWidth());
        double wx1 = xAxis.translateToWorld(x1, dimensions.getWidth());
        double wy0 = yAxis.translateToWorld(y0, dimensions.getHeight());
        double wy1 = yAxis.translateToWorld(y1, dimensions.getHeight());
        double wz0 = zAxis.translateToWorld(z0, dimensions.getDepth());
        double wz1 = zAxis.translateToWorld(z1, dimensions.getDepth());
        Line3D line = new Line3D(wx0, wy0, wz0, wx1, wy1, wz1);
        if ((line = Line3D.cropLineToAxisAlignedBoundingBox(line, 0.0, dimensions.getWidth(), 0.0, dimensions.getHeight(), 0.0, dimensions.getDepth())) != null) {
            Color color = this.getColorSource().getColor(series, item);
            LineObject3D line3D = new LineObject3D((float)(line.getStart().getX() + xOffset), (float)(line.getStart().getY() + yOffset), (float)(line.getStart().getZ() + zOffset), (float)(line.getEnd().getX() + xOffset), (float)(line.getEnd().getY() + yOffset), (float)(line.getEnd().getZ() + zOffset), color);
            world.add(line3D);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LineXYZRenderer)) {
            return false;
        }
        LineXYZRenderer that = (LineXYZRenderer)obj;
        return super.equals(obj);
    }
}

