/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.table;

import com.orsoncharts.table.AbstractTableElement;
import com.orsoncharts.table.ContainerElement;
import com.orsoncharts.table.ElementDimension;
import com.orsoncharts.table.ElementInfo;
import com.orsoncharts.table.TableElement;
import com.orsoncharts.table.TableElementOnDraw;
import com.orsoncharts.table.TableElementVisitor;
import com.orsoncharts.table.VAlign;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.Fit2D;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VerticalFlowElement
extends AbstractTableElement
implements ContainerElement,
Serializable {
    private List<TableElement> elements;
    private VAlign verticalAlignment;
    private int vgap;

    public VerticalFlowElement() {
        this(VAlign.MIDDLE, 2);
    }

    public VerticalFlowElement(VAlign alignment, int vgap) {
        ArgChecks.nullNotPermitted((Object)alignment, null);
        this.elements = new ArrayList<TableElement>();
        this.verticalAlignment = alignment;
        this.vgap = vgap;
    }

    public VAlign getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VAlign alignment) {
        ArgChecks.nullNotPermitted((Object)alignment, "alignment");
        this.verticalAlignment = alignment;
    }

    public int getVGap() {
        return this.vgap;
    }

    public void setVGap(int vgap) {
        this.vgap = vgap;
    }

    public List<TableElement> getElements() {
        return new ArrayList<TableElement>(this.elements);
    }

    @Override
    public void addElement(TableElement element) {
        ArgChecks.nullNotPermitted(element, "element");
        this.elements.add(element);
    }

    @Override
    public void receive(TableElementVisitor visitor) {
        for (TableElement element : this.elements) {
            element.receive(visitor);
        }
    }

    @Override
    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        List<ElementInfo> elementsInColumn;
        Insets insets = this.getInsets();
        double width = insets.left + insets.right;
        double height = insets.top + insets.bottom;
        double maxColHeight = 0.0;
        int elementCount = this.elements.size();
        for (int i = 0; i < elementCount; i += elementsInColumn.size()) {
            elementsInColumn = this.columnOfElements(i, g2, bounds);
            double colWidth = this.calcColumnWidth(elementsInColumn);
            double colHeight = this.calcColumnHeight(elementsInColumn, this.vgap);
            maxColHeight = Math.max(colHeight, maxColHeight);
            width += colWidth;
        }
        return new ElementDimension(width, height += maxColHeight);
    }

    private List<ElementInfo> columnOfElements(int first, Graphics2D g2, Rectangle2D bounds) {
        ArrayList<ElementInfo> result = new ArrayList<ElementInfo>();
        int index = first;
        boolean full = false;
        double h = this.getInsets().top + this.getInsets().bottom;
        while (index < this.elements.size() && !full) {
            TableElement element = this.elements.get(index);
            Dimension2D dim = element.preferredSize(g2, bounds);
            if (h + dim.getHeight() <= bounds.getHeight() || index == first) {
                result.add(new ElementInfo(element, dim));
                h += dim.getHeight() + (double)this.vgap;
                ++index;
                continue;
            }
            full = true;
        }
        return result;
    }

    private double calcColumnWidth(List<ElementInfo> elementInfoList) {
        double result = 0.0;
        for (ElementInfo elementInfo : elementInfoList) {
            result = Math.max(result, elementInfo.getDimension().getWidth());
        }
        return result;
    }

    private double calcColumnHeight(List<ElementInfo> elementInfoList, double vgap) {
        double result = 0.0;
        for (ElementInfo elementInfo : elementInfoList) {
            result += elementInfo.getDimension().getHeight();
        }
        int count = elementInfoList.size();
        if (count > 1) {
            result += (double)(count - 1) * vgap;
        }
        return result;
    }

    @Override
    public List<Rectangle2D> layoutElements(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        int elementCount = this.elements.size();
        ArrayList<Rectangle2D> result = new ArrayList<Rectangle2D>(elementCount);
        int i = 0;
        double x = bounds.getX() + (double)this.getInsets().left;
        double y = bounds.getY() + (double)this.getInsets().top;
        while (i < elementCount) {
            List<ElementInfo> elementsInColumn = this.columnOfElements(i, g2, bounds);
            double width = this.calcColumnWidth(elementsInColumn);
            double height = this.calcColumnHeight(elementsInColumn, this.vgap);
            if (this.verticalAlignment == VAlign.MIDDLE) {
                y = bounds.getCenterY() - height / 2.0;
            } else if (this.verticalAlignment == VAlign.BOTTOM) {
                y = bounds.getMaxY() - (double)this.getInsets().bottom - height;
            }
            for (ElementInfo elementInfo : elementsInColumn) {
                Dimension2D dim = elementInfo.getDimension();
                Rectangle2D.Double position = new Rectangle2D.Double(x, y, width, dim.getHeight());
                result.add(position);
                y += ((RectangularShape)position).getHeight() + (double)this.vgap;
            }
            i += elementsInColumn.size();
            x += width;
            y = bounds.getY() + (double)this.getInsets().top;
        }
        return result;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds) {
        this.draw(g2, bounds, null);
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds, TableElementOnDraw onDrawHandler) {
        if (onDrawHandler != null) {
            onDrawHandler.beforeDraw(this, g2, bounds);
        }
        Shape savedClip = g2.getClip();
        g2.clip(bounds);
        Dimension2D prefDim = this.preferredSize(g2, bounds);
        Fit2D fitter = Fit2D.getNoScalingFitter(this.getRefPoint());
        Rectangle2D dest = fitter.fit(prefDim, bounds);
        List<Rectangle2D> layoutInfo = this.layoutElements(g2, dest, null);
        for (int i = 0; i < this.elements.size(); ++i) {
            Rectangle2D rect = layoutInfo.get(i);
            TableElement element = this.elements.get(i);
            element.draw(g2, rect, onDrawHandler);
        }
        g2.setClip(savedClip);
        if (onDrawHandler != null) {
            onDrawHandler.afterDraw(this, g2, bounds);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VerticalFlowElement)) {
            return false;
        }
        VerticalFlowElement that = (VerticalFlowElement)obj;
        if (this.vgap != that.vgap) {
            return false;
        }
        if (this.verticalAlignment != that.verticalAlignment) {
            return false;
        }
        if (!this.elements.equals(that.elements)) {
            return false;
        }
        return super.equals(obj);
    }
}

