/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.util;

public final class ArgChecks {
    private ArgChecks() {
    }

    public static void nullNotPermitted(Object arg, String name) {
        if (arg == null) {
            throw new IllegalArgumentException("Null '" + name + "' argument.");
        }
    }

    public static void negativeNotPermitted(double value, String name) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Param '" + name + "' cannot be negative");
        }
    }

    public static void positiveRequired(double value, String name) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("Param '" + name + "' must be positive.");
        }
    }

    public static void finiteRequired(double value, String name) {
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("Param '" + name + "' must be finite.");
        }
    }

    public static void finitePositiveRequired(double value, String name) {
        if (value <= 0.0 || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Param '" + name + "' must be finite and positive.");
        }
    }

    public static void checkArrayBounds(int index, String name, int arrayLimit) {
        if (index >= arrayLimit) {
            throw new IllegalArgumentException("Requires '" + name + "' in the range 0 to " + (arrayLimit - 1));
        }
    }
}

