/*
 * Decompiled with CFR 0.152.
 */
package com.oblac.rup;

public class GithubRepo {
    String user;
    String repo;
    String branch;
    String host;
    String protocol;
    boolean enterprise;

    public String getUser() {
        return this.user;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getHost() {
        return this.host;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isEnterprise() {
        return this.enterprise;
    }

    public String toApiUrl() {
        if (this.isEnterprise()) {
            return "https://" + this.host + "/api/v3/repos/" + this.user + "/" + this.repo;
        }
        return "https://api.github.com/repos/" + this.user + "/" + this.repo;
    }

    public String toTarballUrl() {
        return this.toApiUrl() + "/tarball/" + this.branch;
    }

    public String toZipUrl() {
        return this.toApiUrl() + "/archive/" + this.branch + ".zip";
    }

    public String toWebUrl() {
        String url = "https://" + this.host + "/" + this.user + "/" + this.repo;
        if (!this.branch.equals("master")) {
            url = url + "/blob/" + this.branch;
        }
        return url;
    }

    public String toTravisUrl() {
        String url = "https://travis-ci.org/" + this.user + "/" + this.repo;
        if (!this.branch.equals("master")) {
            url = url + "?branch=" + this.branch;
        }
        return url;
    }
}

