/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.assertion;

import com.obsidiandynamics.assertion.AssertionsEnabledUncovered;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public final class Assertions {
    private Assertions() {
    }

    public static boolean areEnabled() {
        return Assertions.not(Assertions.assertRunnable(Assertions.asserterOfTrue(false)));
    }

    public static void runIfEnabled(Runnable runnable) {
        Assertions.runIf(Assertions::areEnabled, runnable);
    }

    static Runnable asserterOfTrue(boolean b) {
        return () -> AssertionsEnabledUncovered.doAssert(b);
    }

    static boolean not(boolean b) {
        return !b;
    }

    static void runIf(BooleanSupplier condition, Runnable runnable) {
        if (condition.getAsBoolean()) {
            runnable.run();
        }
    }

    public static void assertCondition(BooleanSupplier condition, String format, Object ... args) {
        Assertions.assertCondition(condition, () -> String.format(format, args));
    }

    public static void assertCondition(BooleanSupplier condition, Supplier<String> messageMaker) {
        Assertions.runIfEnabled(() -> {
            if (!condition.getAsBoolean()) {
                throw new AssertionError(messageMaker.get());
            }
        });
    }

    public static boolean assertRunnable(Runnable r) {
        try {
            r.run();
            return true;
        }
        catch (AssertionError e) {
            return false;
        }
    }

    public static void assertToStringOverride(Object obj) {
        String objectToString = obj.getClass().getName() + "@" + Integer.toHexString(obj.hashCode());
        String actualToString = obj.toString();
        if (Objects.equals(actualToString, objectToString)) {
            throw new AssertionError((Object)"The toString() method does not appear to have been overridden");
        }
    }

    public static void assertUtilityClassWellDefined(Class<?> cls) {
        if (!Modifier.isFinal(cls.getModifiers())) {
            throw new AssertionError((Object)"Class must be final");
        }
        if (cls.getDeclaredConstructors().length != 1) {
            throw new AssertionError((Object)"There must be exactly one construtor");
        }
        try {
            Constructor<?> constructor = cls.getDeclaredConstructor(new Class[0]);
            if (!Modifier.isPrivate(constructor.getModifiers())) {
                throw new AssertionError((Object)"Constructor is not private");
            }
            constructor.setAccessible(true);
            constructor.newInstance(new Object[0]);
            constructor.setAccessible(false);
            for (Method method : cls.getDeclaredMethods()) {
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new AssertionError((Object)("There exists a non-static method: " + method));
                }
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

