/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.concat;

import java.util.function.Consumer;

public final class Concat
implements CharSequence {
    private final StringBuilder sb;

    public Concat() {
        this(new StringBuilder());
    }

    public Concat(CharSequence cs) {
        this(new StringBuilder(cs));
    }

    public Concat(StringBuilder sb) {
        this.sb = sb;
    }

    public Concat append(Object obj) {
        this.sb.append(obj);
        return this;
    }

    public Concat appendArray(String separator, Object ... objs) {
        for (int i = 0; i < objs.length; ++i) {
            this.append(objs[i]).when(i < objs.length - 1).append(separator);
        }
        return this;
    }

    public ConditionalConcat when(boolean condition) {
        return new ConditionalConcat(condition);
    }

    public ConditionalConcat whenIsNull(Object obj) {
        return this.when(obj == null);
    }

    public ConditionalConcat whenIsNotNull(Object obj) {
        return this.when(obj != null);
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    public final class ConditionalConcat {
        private final boolean conditionMet;

        ConditionalConcat(boolean conditionMet) {
            this.conditionMet = conditionMet;
        }

        public Concat append(Object obj) {
            return this.conditional(c -> c.append(obj));
        }

        public Concat appendArray(String separator, Object ... objs) {
            return this.conditional(c -> c.appendArray(separator, objs));
        }

        private Concat conditional(Consumer<Concat> lambda) {
            if (this.conditionMet) {
                lambda.accept(Concat.this);
            }
            return Concat.this;
        }
    }
}

