/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.dockercompose;

import com.obsidiandynamics.concat.Concat;
import com.obsidiandynamics.dockercompose.DockerComposeException;
import com.obsidiandynamics.shell.ProcessExecutor;
import com.obsidiandynamics.shell.RunningProcess;
import com.obsidiandynamics.shell.Shell;
import com.obsidiandynamics.shell.Sink;

public final class DockerCompose {
    private String composeFile;
    private String project;
    private Shell shell = Shell.getDefault();
    private ProcessExecutor executor = ProcessExecutor.getDefault();
    private Sink sink;
    private boolean echo;

    public DockerCompose withComposeFile(String composeFile) {
        this.composeFile = composeFile;
        return this;
    }

    public DockerCompose withProject(String project) {
        this.project = project;
        return this;
    }

    public DockerCompose withShell(Shell shell) {
        this.shell = shell;
        return this;
    }

    public DockerCompose withExecutor(ProcessExecutor executor) {
        this.executor = executor;
        return this;
    }

    public DockerCompose withEcho(boolean echo) {
        this.echo = echo;
        return this;
    }

    public DockerCompose withSink(Sink sink) {
        this.sink = sink;
        return this;
    }

    public void checkInstalled() {
        Shell.builder().withShell(this.shell).withExecutor(this.executor).checkInstalled(new String[]{"docker-compose version"});
    }

    private void ensureComposeFileAssigned() {
        if (this.composeFile == null) {
            throw new IllegalStateException("Compose file must be assigned");
        }
    }

    public void up() throws DockerComposeException {
        this.ensureComposeFileAssigned();
        Concat cmd = new Concat((CharSequence)"docker-compose").whenIsNotNull((Object)this.project).append((Object)new StringBuilder(" -p ").append(this.project)).append((Object)" -f ").append((Object)this.composeFile).append((Object)" up --no-color -d");
        this.run(cmd.toString());
    }

    public void down(boolean removeVolumes) throws DockerComposeException {
        this.ensureComposeFileAssigned();
        Concat cmd = new Concat((CharSequence)"docker-compose").whenIsNotNull((Object)this.project).append((Object)new StringBuilder(" -p ").append(this.project)).append((Object)" -f ").append((Object)this.composeFile).append((Object)" down").when(removeVolumes).append((Object)" -v");
        this.run(cmd.toString());
    }

    public void stop(int timeout) throws DockerComposeException {
        this.ensureComposeFileAssigned();
        Concat cmd = new Concat((CharSequence)"docker-compose").whenIsNotNull((Object)this.project).append((Object)new StringBuilder(" -p ").append(this.project)).append((Object)" -f ").append((Object)this.composeFile).append((Object)" stop").when(timeout != 0).append((Object)new StringBuilder(" -t ").append(timeout));
        this.run(cmd.toString());
    }

    public void rm(boolean removeVolumes) throws DockerComposeException {
        this.ensureComposeFileAssigned();
        Concat cmd = new Concat((CharSequence)"docker-compose").whenIsNotNull((Object)this.project).append((Object)new StringBuilder(" -p ").append(this.project)).append((Object)" -f ").append((Object)this.composeFile).append((Object)" rm -f").when(removeVolumes).append((Object)" -v");
        this.run(cmd.toString());
    }

    private void run(String command) throws DockerComposeException {
        StringBuilder out = new StringBuilder();
        RunningProcess proc = Shell.builder().withShell(this.shell).withExecutor(this.executor).execute(new String[]{command});
        if (this.echo) {
            proc.echo(out::append);
        }
        int exitCode = proc.pipeTo(out::append).await();
        if (this.sink != null) {
            this.sink.accept((Object)out.toString());
            this.sink.accept((Object)"\n");
        }
        if (exitCode != 0) {
            throw new DockerComposeException(command, out.toString(), exitCode);
        }
    }
}

