/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.func;

import com.obsidiandynamics.func.Classes;
import java.lang.reflect.Array;

public final class ArrayCopy {
    private ArrayCopy() {
    }

    public static <T> T grow(T source, int addElements, int shiftOrigin) {
        if (addElements < 0) {
            throw new IllegalArgumentException("Number of elements to add cannot be negative");
        }
        if (shiftOrigin < 0) {
            throw new IllegalArgumentException("The shift magnitude cannot be negative");
        }
        if (shiftOrigin > addElements) {
            throw new IllegalArgumentException("Cannot shift by more than the number of added elements");
        }
        int length = ArrayCopy.lengthOf(source);
        T a = ArrayCopy.clear(source, length + addElements);
        System.arraycopy(source, 0, a, shiftOrigin, length);
        return a;
    }

    public static <T> T append(T source, Object tailElement) {
        T grown = ArrayCopy.grow(source, 1, 0);
        int initialLength = Array.getLength(source);
        Array.set(grown, initialLength, tailElement);
        return grown;
    }

    public static <T> T append(T source, Object ... tailElements) {
        int toAdd = tailElements.length;
        T grown = ArrayCopy.grow(source, toAdd, 0);
        int initialLength = Array.getLength(source);
        for (int i = 0; i < toAdd; ++i) {
            Array.set(grown, initialLength + i, tailElements[i]);
        }
        return grown;
    }

    public static <T> T slice(T source, int fromInclusive, int toExclusive) {
        int length = ArrayCopy.lengthOf(source);
        if (toExclusive > length) {
            throw new ArrayIndexOutOfBoundsException("The 'to' offset exceed the size of the array");
        }
        if (fromInclusive < 0) {
            throw new ArrayIndexOutOfBoundsException("The 'from' offset cannot be negative");
        }
        if (fromInclusive > toExclusive) {
            throw new ArrayIndexOutOfBoundsException("The 'from' and 'to' offsets may not cross");
        }
        int newLength = toExclusive - fromInclusive;
        T a = ArrayCopy.clear(source, newLength);
        System.arraycopy(source, fromInclusive, a, 0, newLength);
        return a;
    }

    private static int lengthOf(Object array) {
        if (array == null) {
            throw new IllegalArgumentException("Null array");
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array");
        }
        return Array.getLength(array);
    }

    public static <T> T clear(T array, int newLength) {
        return ArrayCopy.allocate((Class)Classes.cast(array.getClass()), newLength);
    }

    public static <T> T allocate(Class<T> arrayType, int length) {
        if (arrayType == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException("Type must be an array");
        }
        Class<?> componentType = arrayType.getComponentType();
        return Classes.cast(Array.newInstance(componentType, length));
    }
}

