/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.func;

import com.obsidiandynamics.func.CheckedRunnable;
import com.obsidiandynamics.func.CheckedSupplier;
import com.obsidiandynamics.func.Classes;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Exceptions {
    private Exceptions() {
    }

    public static <X extends Throwable> void wrap(CheckedRunnable<?> runnable, Function<Throwable, ? extends X> wrapper) throws X {
        Exceptions.wrap(() -> {
            runnable.run();
            return null;
        }, wrapper);
    }

    public static <X extends Throwable> void wrapRunnable(CheckedRunnable<?> runnable, Function<Throwable, ? extends X> wrapper) throws X {
        Exceptions.wrap(runnable, wrapper);
    }

    public static <T, X extends Throwable> T wrap(CheckedSupplier<? extends T, ?> supplier, Function<Throwable, ? extends X> wrapper) throws X {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            throw (Throwable)wrapper.apply((Throwable)Classes.cast(e));
        }
    }

    public static <W extends Throwable, X extends Throwable> void wrapStrict(CheckedRunnable<? extends W> runnable, Function<? super W, ? extends X> wrapper) throws X {
        Exceptions.wrapStrict(() -> {
            runnable.run();
            return null;
        }, wrapper);
    }

    public static <T, W extends Throwable, X extends Throwable> T wrapStrict(CheckedSupplier<? extends T, W> supplier, Function<? super W, ? extends X> wrapper) throws X {
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw (Throwable)wrapper.apply(Classes.cast(e));
        }
    }

    public static <T, X extends Throwable> T wrapSupplier(CheckedSupplier<? extends T, ?> supplier, Function<Throwable, ? extends X> wrapper) throws X {
        return Exceptions.wrap(supplier, wrapper);
    }

    public static <X extends Throwable> CheckedRunnable<X> doThrow(Supplier<? extends X> exceptionMaker) {
        return () -> {
            throw (Throwable)exceptionMaker.get();
        };
    }

    public static Throwable unwrap(Class<? extends Throwable> containerExceptionType, Throwable throwable) {
        if (containerExceptionType.isInstance(throwable)) {
            return throwable.getCause();
        }
        return throwable;
    }
}

