/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.func;

import com.obsidiandynamics.func.CheckedConsumer;
import com.obsidiandynamics.func.CheckedFunction;
import com.obsidiandynamics.func.CheckedRunnable;
import com.obsidiandynamics.func.CheckedSupplier;
import com.obsidiandynamics.func.Classes;
import com.obsidiandynamics.func.ExceptionHandler;
import com.obsidiandynamics.func.Exceptions;
import com.obsidiandynamics.func.NullArgumentException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class Functions {
    private Functions() {
    }

    public static <U, V, X extends Throwable> CheckedSupplier<V, X> chain(CheckedSupplier<U, ? extends X> before, CheckedFunction<U, V, ? extends X> after) throws X {
        return () -> after.apply(before.get());
    }

    public static <U, V, W, X extends Throwable> CheckedFunction<U, W, X> chain(CheckedFunction<U, V, X> before, CheckedFunction<V, W, X> after) throws X {
        return before.andThen(after);
    }

    public static <U, V, X extends Throwable> CheckedConsumer<U, X> chain(CheckedFunction<U, V, X> before, CheckedConsumer<V, X> after) throws X {
        return u -> after.accept(before.apply(u));
    }

    public static <K, U, V, X extends Throwable> LinkedHashMap<K, V> mapValues(Map<K, ? extends U> source, CheckedFunction<? super U, ? extends V, ? extends X> mapper) throws X {
        return Functions.mapValues(source, mapper, LinkedHashMap::new);
    }

    public static <K, U, V, M extends Map<K, V>, X extends Throwable> M mapValues(Map<K, ? extends U> source, CheckedFunction<? super U, ? extends V, ? extends X> mapper, Supplier<M> mapMaker) throws X {
        if (source != null) {
            Map mapped = (Map)mapMaker.get();
            for (Map.Entry<K, U> entry : source.entrySet()) {
                mapped.put(entry.getKey(), mapper.apply(entry.getValue()));
            }
            return (M)mapped;
        }
        return null;
    }

    public static <U, V, X extends Throwable> ArrayList<V> mapCollection(Collection<? extends U> source, CheckedFunction<? super U, ? extends V, ? extends X> mapper) throws X {
        return Functions.mapCollection(source, mapper, ArrayList::new);
    }

    public static <U, V, C extends Collection<V>, X extends Throwable> C mapCollection(Collection<? extends U> source, CheckedFunction<? super U, ? extends V, ? extends X> mapper, Supplier<C> collectionMaker) throws X {
        if (source != null) {
            Collection mapped = (Collection)collectionMaker.get();
            for (U item : source) {
                mapped.add(mapper.apply(item));
            }
            return (C)mapped;
        }
        return null;
    }

    public static <U, V, X extends Exception> ArrayList<V> parallelMapStream(Stream<? extends U> source, CheckedFunction<? super U, ? extends V, ? extends X> mapper, ExecutorService executor) throws X, InterruptedException {
        return Functions.parallelMapStream(source, mapper, ArrayList::new, executor);
    }

    public static <U, V, C extends Collection<V>, X extends Throwable> C parallelMapStream(Stream<? extends U> source, CheckedFunction<? super U, ? extends V, ? extends X> mapper, Supplier<C> collectionMaker, ExecutorService executor) throws X, InterruptedException {
        ArrayList submissions = new ArrayList();
        source.forEach(item -> submissions.add(executor.submit(() -> Exceptions.wrap(() -> mapper.apply((Object)item), CapturedException::new))));
        Collection mapped = (Collection)collectionMaker.get();
        for (Future future : submissions) {
            try {
                mapped.add(future.get());
            }
            catch (ExecutionException e) {
                Throwable cause = CapturedException.unwind(e.getCause());
                throw (Throwable)Classes.cast(cause);
            }
        }
        return (C)mapped;
    }

    public static <T, X extends Throwable> void forEach(Collection<? extends T> collection, CheckedConsumer<? super T, ? extends X> consumer) throws X {
        for (T element : collection) {
            consumer.accept(element);
        }
    }

    public static Supplier<IllegalStateException> illegalState(String message) {
        return Functions.withMessage(message, IllegalStateException::new);
    }

    public static Supplier<IllegalArgumentException> illegalArgument(String message) {
        return Functions.withMessage(message, IllegalArgumentException::new);
    }

    public static <X extends Throwable> Supplier<X> withMessage(String message, Function<String, ? extends X> exceptionMaker) {
        return () -> (Throwable)exceptionMaker.apply(message);
    }

    public static <X extends Throwable> Supplier<X> withMessage(Supplier<String> messageSupplier, Function<String, ? extends X> exceptionMaker) {
        return () -> (Throwable)exceptionMaker.apply((String)messageSupplier.get());
    }

    public static <K, V, X extends Throwable> V mustExist(Map<K, V> map, K key, String errorTemplate, Function<String, ? extends X> exceptionMaker) throws X {
        return Functions.mustExist(map.get(key), Functions.withMessage(() -> String.format(errorTemplate, key), exceptionMaker));
    }

    public static <T> T mustExist(T value) throws NullArgumentException {
        return Functions.mustExist(value, NullArgumentException::new);
    }

    public static <T> T mustExist(T value, String message) throws NullArgumentException {
        return Functions.mustExist(value, Functions.withMessage(message, NullArgumentException::new));
    }

    public static <T, X extends Throwable> T mustExist(T value, Supplier<? extends X> exceptionMaker) throws X {
        if (value != null) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> void mustBeNull(Object value, Supplier<? extends X> exceptionMaker) throws X {
        Functions.mustBeTrue(value == null, exceptionMaker);
    }

    public static <C extends Collection<?>, X extends Throwable> C mustNotBeEmpty(C collection, String message) throws X {
        return Functions.mustNotBeEmpty(collection, Functions.illegalArgument(message));
    }

    public static <C extends Collection<?>, X extends Throwable> C mustNotBeEmpty(C collection, Supplier<? extends X> exceptionMaker) throws X {
        if (!collection.isEmpty()) {
            return collection;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <M extends Map<?, ?>, X extends Throwable> M mustNotBeEmpty(M map, Supplier<? extends X> exceptionMaker) throws X {
        if (!map.isEmpty()) {
            return map;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> String mustNotBeEmpty(String string, String message) throws X {
        return Functions.mustNotBeEmpty(string, Functions.illegalArgument(message));
    }

    public static <X extends Throwable> String mustNotBeEmpty(String string, Supplier<? extends X> exceptionMaker) throws X {
        if (!string.isEmpty()) {
            return string;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <T, X extends Throwable> T mustBeSubtype(Object value, Class<T> type, Supplier<? extends X> exceptionMaker) throws X {
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> void mustBeEqual(Object expected, Object actual, Supplier<? extends X> exceptionMaker) throws X {
        Functions.mustBeTrue(Objects.equals(expected, actual), exceptionMaker);
    }

    public static <T, X extends Throwable> T mustNotBeEqual(Object unexpected, T actual, Supplier<? extends X> exceptionMaker) throws X {
        Functions.mustBeFalse(Objects.equals(unexpected, actual), exceptionMaker);
        return actual;
    }

    public static <X extends Throwable> void mustBeTrue(boolean test, Supplier<? extends X> exceptionMaker) throws X {
        if (!test) {
            throw (Throwable)exceptionMaker.get();
        }
    }

    public static <X extends Throwable> void mustBeFalse(boolean test, Supplier<? extends X> exceptionMaker) throws X {
        if (test) {
            throw (Throwable)exceptionMaker.get();
        }
    }

    public static <X extends Throwable> long mustBeGreater(long value, long comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value > comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> long mustBeGreaterOrEqual(long value, long comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value >= comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> long mustBeLess(long value, long comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value < comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> long mustBeLessOrEqual(long value, long comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value <= comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> int mustBeGreater(int value, int comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value > comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> int mustBeGreaterOrEqual(int value, int comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value >= comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> int mustBeLess(int value, int comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value < comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> int mustBeLessOrEqual(int value, int comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value <= comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> double mustBeGreater(double value, double comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value > comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> double mustBeGreaterOrEqual(double value, double comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value >= comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> double mustBeLess(double value, double comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value < comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> double mustBeLessOrEqual(double value, double comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value <= comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> float mustBeGreater(float value, float comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value > comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> float mustBeGreaterOrEqual(float value, float comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value >= comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> float mustBeLess(float value, float comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value < comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <X extends Throwable> float mustBeLessOrEqual(float value, float comparand, Supplier<? extends X> exceptionMaker) throws X {
        if (value <= comparand) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <T extends Comparable<T>, X extends Throwable> T mustBeGreater(T value, T comparand, Supplier<? extends X> exceptionMaker) throws X {
        Functions.mustExist(value);
        Functions.mustExist(comparand);
        if (value.compareTo(comparand) > 0) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <T extends Comparable<T>, X extends Throwable> T mustBeGreaterOrEqual(T value, T comparand, Supplier<? extends X> exceptionMaker) throws X {
        Functions.mustExist(value);
        Functions.mustExist(comparand);
        if (value.compareTo(comparand) >= 0) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <T extends Comparable<T>, X extends Throwable> T mustBeLess(T value, T comparand, Supplier<? extends X> exceptionMaker) throws X {
        Functions.mustExist(value);
        Functions.mustExist(comparand);
        if (value.compareTo(comparand) < 0) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <T extends Comparable<T>, X extends Throwable> T mustBeLessOrEqual(T value, T comparand, Supplier<? extends X> exceptionMaker) throws X {
        Functions.mustExist(value);
        Functions.mustExist(comparand);
        if (value.compareTo(comparand) <= 0) {
            return value;
        }
        throw (Throwable)exceptionMaker.get();
    }

    public static <T, U, X extends Throwable> U ifPresentOptional(Optional<T> value, CheckedFunction<? super T, ? extends U, X> mapper) throws X {
        return Functions.ifPresent(value.orElse(null), mapper);
    }

    public static <T, U, X extends Throwable> U ifPresent(T value, CheckedFunction<? super T, ? extends U, X> mapper) throws X {
        return value != null ? (U)mapper.apply((T)value) : null;
    }

    public static <T, X extends Throwable> void ifPresentVoid(T value, CheckedConsumer<? super T, X> consumer) throws X {
        if (value != null) {
            consumer.accept(value);
        }
    }

    public static <T, X extends Throwable> T ifAbsentOptional(Optional<T> value, CheckedSupplier<? extends T, X> supplier) throws X {
        return Functions.ifAbsent(value.orElse(null), supplier);
    }

    public static <T, X extends Throwable> T ifAbsent(T value, CheckedSupplier<? extends T, X> supplier) throws X {
        return value != null ? value : supplier.get();
    }

    public static <T, U, X extends Throwable> U ifEitherOptional(Optional<T> value, CheckedFunction<? super T, ? extends U, X> mapperIfPresent, CheckedSupplier<? extends U, X> supplierIfAbsent) throws X {
        return Functions.ifEither(value.orElse(null), mapperIfPresent, supplierIfAbsent);
    }

    public static <T, U, X extends Throwable> U ifEither(T value, CheckedFunction<? super T, ? extends U, X> mapperIfPresent, CheckedSupplier<? extends U, X> supplierIfAbsent) throws X {
        return value != null ? mapperIfPresent.apply(value) : supplierIfAbsent.get();
    }

    public static <T> T ifThrew(CheckedSupplier<? extends T, ? extends Throwable> preferredSupplier, Supplier<? extends T> fallbackSupplier) {
        try {
            return preferredSupplier.get();
        }
        catch (Throwable e) {
            return fallbackSupplier.get();
        }
    }

    public static <T> CheckedSupplier<T, RuntimeException> giveNull() {
        return () -> null;
    }

    public static <T> Supplier<T> givePlainNull() {
        return () -> null;
    }

    public static <T> CheckedSupplier<T, RuntimeException> give(T value) {
        return () -> value;
    }

    public static <T> Supplier<T> givePlain(T value) {
        return () -> value;
    }

    public static Consumer<Throwable> withSummary(String summary, ExceptionHandler exceptionHandler) {
        return cause -> exceptionHandler.onException(summary, (Throwable)cause);
    }

    public static void tryCatch(CheckedRunnable<?> errorProneRunnable, Consumer<Throwable> onError) {
        try {
            errorProneRunnable.run();
        }
        catch (Throwable e) {
            onError.accept(e);
        }
    }

    public static <T> T tryCatch(CheckedSupplier<? extends T, ?> errorProneSupplier, Supplier<? extends T> defaultValueSupplier, Consumer<Throwable> onError) {
        try {
            return errorProneSupplier.get();
        }
        catch (Throwable e) {
            onError.accept(e);
            return defaultValueSupplier.get();
        }
    }

    public static Consumer<Throwable> ignoreException() {
        return __ -> {};
    }

    public static <T, U> Comparator<T> byField(Function<T, U> fieldExtractor, Comparator<? super U> fieldComparator) {
        return (t0, t1) -> {
            Object field0 = fieldExtractor.apply(t0);
            Object field1 = fieldExtractor.apply(t1);
            return fieldComparator.compare((Object)field0, (Object)field1);
        };
    }

    public static <U, X extends Throwable> CheckedFunction<U, Void, X> voidFunction(CheckedConsumer<? super U, ? extends X> consumer) {
        return u -> {
            consumer.accept((Object)u);
            return null;
        };
    }

    public static <T, U> Predicate<T> fieldPredicate(Function<? super T, ? extends U> fieldExtractor, Predicate<? super U> fieldPredicate) {
        return element -> fieldPredicate.test((Object)fieldExtractor.apply(element));
    }

    static final class CapturedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        CapturedException(Throwable cause) {
            super(cause);
        }

        static Throwable unwind(Throwable throwable) {
            for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof CapturedException)) continue;
                return cause.getCause();
            }
            throw new IllegalStateException("Could not unwind the correct cause", throwable);
        }
    }
}

