/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.func.tuple;

import com.obsidiandynamics.func.Classes;
import com.obsidiandynamics.func.Functions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;

public abstract class AbstractTuple
implements Comparable<AbstractTuple> {
    private final Object[] elements;

    protected AbstractTuple(Object ... elements) {
        this.elements = elements;
    }

    protected final <T> T get(int elementIndex) {
        return Classes.cast(this.elements[elementIndex]);
    }

    public final int hashCode() {
        return Arrays.deepHashCode(this.elements);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            AbstractTuple that = (AbstractTuple)obj;
            return Arrays.deepEquals(this.elements, that.elements);
        }
        return false;
    }

    protected Function<Object, String> getFormatter(int elementIndex) {
        return Object::toString;
    }

    protected Comparator<?> getComparator(int elementIndex) {
        Functions.mustBeGreaterOrEqual(elementIndex, false, IndexOutOfBoundsException::new);
        return Comparator.nullsFirst(Comparator.naturalOrder());
    }

    @Override
    public final int compareTo(AbstractTuple other) {
        return AbstractTuple.compareElements(this, other);
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append(" [");
        for (int elementIndex = 0; elementIndex < this.elements.length; ++elementIndex) {
            String str = this.getFormatter(elementIndex).apply(this.elements[elementIndex]);
            buffer.append(str);
            if (elementIndex >= this.elements.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static final Comparator<AbstractTuple> defaultComparator() {
        return AbstractTuple::compareElements;
    }

    public static final int compareElements(AbstractTuple x, AbstractTuple y) {
        Functions.mustBeEqual(x.getClass(), y.getClass(), Functions.withMessage(() -> "Classes are not mutually comparable: " + x.getClass().getName() + " and " + y.getClass().getName(), IllegalArgumentException::new));
        for (int elementIndex = 0; elementIndex < x.elements.length; ++elementIndex) {
            Object xElement = x.elements[elementIndex];
            Object yElement = y.elements[elementIndex];
            Comparator comparator = (Comparator)Classes.cast(x.getComparator(elementIndex));
            int comparison = comparator.compare(xElement, yElement);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }
}

