/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.func;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class PredicateChain<T> {
    private final List<Predicate<? super T>> predicates = new ArrayList<Predicate<? super T>>();

    public PredicateChain<T> chain(Predicate<? super T> predicate) {
        this.predicates.add(predicate);
        return this;
    }

    public Predicate<T> allMatch() {
        return t -> {
            for (Predicate<Object> predicate : this.predicates) {
                if (predicate.test(t)) continue;
                return false;
            }
            return true;
        };
    }

    public Predicate<T> anyMatch() {
        return t -> {
            for (Predicate<Object> predicate : this.predicates) {
                if (!predicate.test(t)) continue;
                return true;
            }
            return false;
        };
    }

    @SafeVarargs
    public static <T> Predicate<T> allOf(Predicate<? super T> ... predicates) {
        PredicateChain<? super T> predicateChain = new PredicateChain<T>();
        for (Predicate<? super T> predicate : predicates) {
            predicateChain.chain(predicate);
        }
        return predicateChain.allMatch();
    }

    @SafeVarargs
    public static <T> Predicate<T> anyOf(Predicate<? super T> ... predicates) {
        PredicateChain<? super T> predicateChain = new PredicateChain<T>();
        for (Predicate<? super T> predicate : predicates) {
            predicateChain.chain(predicate);
        }
        return predicateChain.anyMatch();
    }
}

