/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.func.fsm;

import com.obsidiandynamics.func.Functions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;

public final class EnumOrder<E extends Enum<E>>
implements Iterable<E> {
    private final Class<E> enumType;
    private final int[] order;

    private EnumOrder(Class<E> enumType, int[] order) {
        this.enumType = enumType;
        this.order = order;
    }

    public E[] ordered() {
        Enum[] world = (Enum[])this.enumType.getEnumConstants();
        Enum[] ordered = (Enum[])this.enumType.getEnumConstants();
        for (Enum en : world) {
            int orderIndex = this.of(en);
            ordered[orderIndex] = en;
        }
        return ordered;
    }

    public E first() {
        Enum[] ordered = this.ordered();
        return (E)ordered[0];
    }

    public E last() {
        Enum[] ordered = this.ordered();
        return (E)ordered[ordered.length - 1];
    }

    public E highest(Collection<E> elements) {
        return this.findExtreme(elements, this.first(), 1);
    }

    public E lowest(Collection<E> elements) {
        return this.findExtreme(elements, this.last(), -1);
    }

    private E findExtreme(Collection<E> elements, E initial, int signum) {
        EnumOrder.ensureNotEmpty(elements);
        Object currentExtreme = initial;
        Comparator<E> comparator = this.comparator();
        for (Enum el : elements) {
            if (comparator.compare(el, currentExtreme) != signum) continue;
            currentExtreme = el;
        }
        return currentExtreme;
    }

    private static void ensureNotEmpty(Collection<?> array) {
        Functions.mustBeTrue(!array.isEmpty(), Functions.illegalArgument("No elements to search"));
    }

    @Override
    public Iterator<E> iterator() {
        return Arrays.asList(this.ordered()).iterator();
    }

    public int of(E en) {
        return this.order[((Enum)en).ordinal()];
    }

    public Comparator<E> comparator() {
        return (s0, s1) -> {
            int order0 = this.of(s0);
            int order1 = this.of(s1);
            return Integer.compare(order0, order1);
        };
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.enumType);
        result = 31 * result + Arrays.hashCode(this.order);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EnumOrder) {
            EnumOrder that = (EnumOrder)obj;
            return Objects.equals(this.enumType, that.enumType) && Arrays.equals(this.order, that.order);
        }
        return false;
    }

    public String toString() {
        return EnumOrder.class.getSimpleName() + " [enumType=" + this.enumType + ", order=" + Arrays.toString(this.order) + "]";
    }

    public static <E extends Enum<E>> EnumOrder<E> capture(Class<E> enumType, E ... orderedEnums) {
        Enum[] world = (Enum[])enumType.getEnumConstants();
        Functions.mustBeEqual(world.length, orderedEnums.length, Functions.illegalArgument("Order omits one or more required enums"));
        int[] order = new int[world.length];
        for (int i = 0; i < world.length; ++i) {
            int index;
            order[i] = index = EnumOrder.indexOfMandatory((Enum)world[i], orderedEnums);
        }
        return new EnumOrder<E>(enumType, order);
    }

    public static <E extends Enum<E>> int indexOf(E en, E[] enums) {
        for (int i = 0; i < enums.length; ++i) {
            if (enums[i] != en) continue;
            return i;
        }
        return -1;
    }

    public static <E extends Enum<E>> int indexOfMandatory(E en, E[] enums) {
        int index = EnumOrder.indexOf(en, enums);
        Functions.mustBeTrue(index != -1, Functions.withMessage(() -> en + " is not among " + Arrays.toString(enums), IllegalArgumentException::new));
        return index;
    }
}

