/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.func.fsm;

import com.obsidiandynamics.func.Functions;
import com.obsidiandynamics.func.fsm.IllegalTransitionException;
import com.obsidiandynamics.func.fsm.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class Transitions<S> {
    private final Map<S, Set<S>> allowed = new HashMap<S, Set<S>>();

    public Allow allow(S from) {
        return new Allow(from);
    }

    private void addAllowed(S from, S[] to) {
        this.allowed.put(from, Arrays.stream(to).collect(Collectors.toSet()));
    }

    public boolean isAllowed(Transition<S> transition) {
        return this.isAllowed(transition.getFrom(), transition.getTo());
    }

    public boolean isAllowed(S from, S to) {
        if (from.equals(to)) {
            return true;
        }
        Set<S> targets = this.allowed.get(from);
        if (targets != null) {
            return targets.contains(to);
        }
        return false;
    }

    public S guard(Transition<S> transition) throws IllegalTransitionException {
        return this.guard(transition.getFrom(), transition.getTo());
    }

    public S guard(S from, S to) throws IllegalTransitionException {
        Functions.mustBeTrue(this.isAllowed(from, to), Functions.withMessage("Cannot transition " + from + " -> " + to, IllegalTransitionException::new));
        return to;
    }

    public Set<S> nonRecurring() {
        Set toStates = this.allowed.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set<S> fromStates = this.allowed.keySet();
        return fromStates.stream().filter(Transitions.not(toStates::contains)).collect(Collectors.toSet());
    }

    public boolean isNonRecurring(S state) {
        Set toStates = this.allowed.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        return !toStates.contains(state);
    }

    public Set<S> terminal() {
        Set toStates = this.allowed.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set<S> fromStates = this.allowed.keySet();
        return toStates.stream().filter(Transitions.not(fromStates::contains)).collect(Collectors.toSet());
    }

    public List<List<S>> shortestPaths(S from, S to) {
        if (from.equals(to)) {
            return Collections.singletonList(Collections.emptyList());
        }
        return this.computePath(Collections.emptyList(), from, to);
    }

    private List<List<S>> computePath(List<S> path, S current, S to) {
        Set<S> nextStates = this.allowed.get(current);
        if (nextStates == null) {
            return Collections.emptyList();
        }
        if (nextStates.contains(to)) {
            return Collections.singletonList(Transitions.join(path, to));
        }
        ArrayList<List<S>> paths = new ArrayList<List<S>>(nextStates.size());
        for (S nextState : nextStates) {
            if (path.contains(nextState)) continue;
            List<List<S>> nextPaths = this.computePath(Transitions.join(path, nextState), nextState, to);
            paths.addAll(nextPaths);
        }
        if (!paths.isEmpty()) {
            return Transitions.shortest(paths);
        }
        return Collections.emptyList();
    }

    static <S> List<List<S>> shortest(List<List<S>> lists) {
        Iterator<List<S>> iterator = lists.iterator();
        ArrayList<List<S>> currentShortest = new ArrayList<List<S>>();
        List<S> firstPath = iterator.next();
        currentShortest.add(firstPath);
        int currentShortestLength = firstPath.size();
        while (iterator.hasNext()) {
            List<S> path = iterator.next();
            int pathLength = path.size();
            if (pathLength == currentShortestLength) {
                currentShortest.add(path);
                continue;
            }
            if (pathLength >= currentShortestLength) continue;
            currentShortest.clear();
            currentShortest.add(path);
            currentShortestLength = pathLength;
        }
        return currentShortest;
    }

    private static <S> List<S> join(List<S> head, S tail) {
        ArrayList<S> grown = new ArrayList<S>(head.size());
        grown.addAll(head);
        grown.add(tail);
        return grown;
    }

    public boolean isTerminal(S state) {
        Set<S> fromStates = this.allowed.keySet();
        return !fromStates.contains(state);
    }

    private static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public int hashCode() {
        return Objects.hashCode(this.allowed);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Transitions) {
            return Objects.equals(this.allowed, ((Transitions)obj).allowed);
        }
        return false;
    }

    public String toString() {
        return Transitions.class.getSimpleName() + " [allowed=" + this.allowed + "]";
    }

    public final class Allow {
        private final S from;

        Allow(S from) {
            this.from = from;
        }

        public Transitions<S> to(S ... to) {
            Transitions.this.addAllowed(this.from, to);
            return Transitions.this;
        }
    }
}

