/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;

public final class ResourceLoader {
    private ResourceLoader() {
    }

    public static InputStream tryStream(URI uri) {
        try {
            return ResourceLoader.stream(uri);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static InputStream stream(URI uri) throws FileNotFoundException {
        switch (uri.getScheme()) {
            case "file": {
                return new FileInputStream(new File(ResourceLoader.stripScheme(uri)));
            }
            case "cp": 
            case "classpath": {
                InputStream in = ResourceLoader.class.getClassLoader().getResourceAsStream(ResourceLoader.stripScheme(uri));
                if (in != null) {
                    return in;
                }
                throw new FileNotFoundException("No such resource '" + uri + "'");
            }
        }
        throw new IllegalArgumentException("Unsupported URI scheme " + uri.getScheme());
    }

    private static String stripScheme(URI uri) {
        return uri.toString().substring((uri.getScheme() + "://").length());
    }
}

