/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.io;

import com.obsidiandynamics.func.Functions;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.function.Supplier;

public final class Sockets {
    private Sockets() {
    }

    public static int getSparePort(int rangeFromIncl, int rangeToExcl) throws PortRangeExhaustedException {
        int randomPort;
        Functions.mustBeTrue((rangeFromIncl >= 1024 ? 1 : 0) != 0, (Supplier)Functions.illegalArgument((String)"Lower port range must include 1024 or higher"));
        Functions.mustBeTrue((rangeFromIncl < rangeToExcl ? 1 : 0) != 0, (Supplier)Functions.illegalArgument((String)"Port range cannot overlap"));
        Functions.mustBeTrue((rangeToExcl <= 65536 ? 1 : 0) != 0, (Supplier)Functions.illegalArgument((String)"Upper port range must exclude 65536 or lower"));
        int currentPort = randomPort = Sockets.randomInRange(rangeFromIncl, rangeToExcl);
        boolean currentAvailable;
        while (!(currentAvailable = Sockets.isLocalPortAvailable(currentPort))) {
            int next = Sockets.nextInRange(currentPort, rangeFromIncl, rangeToExcl);
            if (next == randomPort) {
                throw new PortRangeExhaustedException("No free ports in range " + rangeFromIncl + " (incl.) to " + rangeToExcl + " (excl.)");
            }
            currentPort = next;
        }
        return currentPort;
    }

    public static boolean isLocalPortAvailable(int port) {
        try {
            try (ServerSocket socket = new ServerSocket();){
                socket.setReuseAddress(true);
                socket.bind(new InetSocketAddress(port));
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    static int randomInRange(int rangeFromIncl, int rangeToExcl) {
        return rangeFromIncl + (int)(Math.random() * (double)(rangeToExcl - rangeFromIncl));
    }

    static int nextInRange(int current, int rangeFromIncl, int rangeToExcl) {
        int range = rangeToExcl - rangeFromIncl;
        return rangeFromIncl + (current - rangeFromIncl + 1) % range;
    }

    public static boolean isRemotePortListening(String host, int port, int timeoutMillis) throws IOException {
        boolean bl;
        Socket s = new Socket();
        try {
            s.setReuseAddress(true);
            s.connect(new InetSocketAddress(host, port), timeoutMillis);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ConnectException | SocketTimeoutException e) {
                return false;
            }
        }
        s.close();
        return bl;
    }

    public static final class PortRangeExhaustedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        PortRangeExhaustedException(String m) {
            super(m);
        }
    }
}

