/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.jgroups;

import com.obsidiandynamics.func.Classes;
import java.net.InetAddress;
import java.util.Optional;
import org.jgroups.JChannel;
import org.jgroups.protocols.BARRIER;
import org.jgroups.protocols.FD_ALL;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FRAG2;
import org.jgroups.protocols.MERGE3;
import org.jgroups.protocols.MFC;
import org.jgroups.protocols.PING;
import org.jgroups.protocols.RSVP;
import org.jgroups.protocols.SHARED_LOOPBACK;
import org.jgroups.protocols.SHARED_LOOPBACK_PING;
import org.jgroups.protocols.UDP;
import org.jgroups.protocols.UFC;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.VERIFY_SUSPECT;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.protocols.pbcast.STATE_TRANSFER;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;

public final class Protocols {
    private Protocols() {
    }

    public static JChannel newUdpChannel(InetAddress bindAddress) throws Exception {
        return new JChannel(new Protocol[]{new UDP().setValue("bind_addr", (Object)bindAddress), new PING(), new MERGE3(), new FD_SOCK(), new FD_ALL(), new VERIFY_SUSPECT(), new BARRIER(), new NAKACK2(), new UNICAST3(), new STABLE(), Protocols.createGMS(), new UFC(), new MFC(), new FRAG2(), new RSVP(), new STATE_TRANSFER()});
    }

    public static JChannel newLoopbackChannel() throws Exception {
        return new JChannel(new Protocol[]{new SHARED_LOOPBACK(), new SHARED_LOOPBACK_PING(), new MERGE3(), new VERIFY_SUSPECT(), new BARRIER(), new NAKACK2(), new UNICAST3(), new STABLE(), Protocols.createGMS(), new UFC(), new MFC(), new FRAG2(), new STATE_TRANSFER()});
    }

    private static GMS createGMS() {
        GMS gms = new GMS();
        gms.setPrintLocalAddr(false);
        return gms;
    }

    public static <P extends Protocol> Optional<P> findProtocol(ProtocolStack protocolStack, Class<P> protocolType) {
        return (Optional)Classes.cast(protocolStack.getProtocols().stream().filter(protocolType::isInstance).findAny());
    }
}

