/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.junit;

import java.util.concurrent.ExecutorService;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class ExecutorProp
implements TestRule {
    private final Supplier<ExecutorService> executorServiceFactory;
    private ExecutorService executor;

    public ExecutorProp(int parallelism, IntFunction<ExecutorService> executorServiceFactory) {
        this(() -> (ExecutorService)executorServiceFactory.apply(parallelism));
    }

    public ExecutorProp(Supplier<ExecutorService> executorServiceFactory) {
        this.executorServiceFactory = executorServiceFactory;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ExecutorProp.this.executor = (ExecutorService)ExecutorProp.this.executorServiceFactory.get();
                try {
                    base.evaluate();
                }
                finally {
                    ExecutorProp.this.executor.shutdownNow();
                    ExecutorProp.this.executor = null;
                }
            }
        };
    }

    public ExecutorService getExecutor() {
        if (this.executor == null) {
            throw new IllegalStateException("Executor not running");
        }
        return this.executor;
    }
}

