/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.junit;

import java.io.PrintStream;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsInstanceOf;

public final class HamcrestMatchers {
    private HamcrestMatchers() {
    }

    private static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static <T> TypedMatcherBuilder<T> instanceOf(Class<? extends T> expectedType) {
        return new TypedMatcherBuilder<T>(expectedType);
    }

    public static <T> Matcher<T> fulfils(final Predicate<? super T> predicate) {
        return new BaseMatcher<T>(){

            public boolean matches(Object item) {
                Object typedItem = HamcrestMatchers.cast(item);
                return predicate.test(typedItem);
            }

            public void describeTo(Description description) {
                description.appendText("fulfils predicate [" + predicate + "]");
            }
        };
    }

    public static <T> Matcher<T> assertedBy(Consumer<? super T> assertion) {
        return HamcrestMatchers.assertedBy(assertion, HamcrestMatchers.forPrintStream(System.err));
    }

    public static Consumer<AssertionError> forPrintStream(PrintStream printStream) {
        return e -> ((Throwable)((Object)e)).printStackTrace(printStream);
    }

    public static <T> Matcher<T> assertedBy(final Consumer<? super T> assertion, final Consumer<? super AssertionError> exceptionHandler) {
        return new BaseMatcher<T>(){

            public boolean matches(Object item) {
                Object typedItem = HamcrestMatchers.cast(item);
                try {
                    assertion.accept(typedItem);
                    return true;
                }
                catch (AssertionError e) {
                    exceptionHandler.accept(e);
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText("asserted by [" + assertion + "]");
            }
        };
    }

    public static final class TypedMatcherBuilder<T> {
        private final Class<? extends T> expectedType;

        TypedMatcherBuilder(Class<? extends T> expectedType) {
            this.expectedType = expectedType;
        }

        public Matcher<Object> thatMatches(Matcher<T> typedMatcher) {
            return (Matcher)HamcrestMatchers.cast(this.thatMatchesStrict(typedMatcher));
        }

        public Matcher<T> thatMatchesStrict(Matcher<T> typedMatcher) {
            Matcher instanceOfMatcher = IsInstanceOf.instanceOf(this.expectedType);
            return AllOf.allOf((Matcher[])new Matcher[]{instanceOfMatcher, typedMatcher});
        }
    }
}

