/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.nodequeue;

import com.obsidiandynamics.nodequeue.LinkedNode;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class QueueConsumer<E>
implements Iterable<E> {
    private AtomicReference<LinkedNode<E>> head;

    QueueConsumer(AtomicReference<LinkedNode<E>> head) {
        this.head = head;
    }

    public E peek() {
        LinkedNode<E> n = this.head.get();
        if (n != null) {
            return n.element;
        }
        return null;
    }

    public E poll() {
        LinkedNode<E> n = this.head.get();
        if (n != null) {
            this.head = n;
            return n.element;
        }
        return null;
    }

    public int drain(List<E> sink) {
        E item;
        int drained = 0;
        while ((item = this.poll()) != null) {
            sink.add(item);
            ++drained;
        }
        return drained;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private E next;
            {
                this.next = QueueConsumer.this.poll();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                try {
                    Object e = this.next;
                    return e;
                }
                finally {
                    this.next = QueueConsumer.this.poll();
                }
            }
        };
    }
}

