/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.shell;

import com.obsidiandynamics.concat.Concat;
import com.obsidiandynamics.shell.CommandTransform;
import com.obsidiandynamics.shell.DefaultProcessExecutor;
import com.obsidiandynamics.shell.Shell;

public final class BourneShell
implements Shell {
    private String path;
    private Variant variant = Variant.SH;

    public BourneShell withPath(String path) {
        this.path = path;
        return this;
    }

    public BourneShell withVariant(Variant variant) {
        this.variant = variant;
        return this;
    }

    @Override
    public String[] prepare(String[] command) {
        return new String[]{this.variant.getShellExecutable(), "-c", this.parseCommand(command)};
    }

    private String parseCommand(String[] command) {
        return new Concat().when(this.path != null).append((Object)new Concat((CharSequence)"export PATH=$PATH:").append((Object)this.path).append((Object)" && ")).appendArray(" ", (Object[])command).toString();
    }

    public static String spliceWithPrompt(String[] command) {
        return "$ " + CommandTransform.splice(command);
    }

    @Override
    public CommandTransform getDefaultEcho() {
        return BourneShell::spliceWithPrompt;
    }

    public static enum Variant {
        SH,
        BASH,
        DASH;


        String getShellExecutable() {
            return this.name().toLowerCase();
        }

        boolean isAvailable() {
            return DefaultProcessExecutor.getInstance().canTryRun(new String[]{"sh", "-c", "pwd"});
        }
    }
}

