/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.shell;

import com.obsidiandynamics.shell.CommandTransform;
import com.obsidiandynamics.shell.ProcessException;
import com.obsidiandynamics.shell.Shell;
import com.obsidiandynamics.shell.Sink;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public final class RunningProcess {
    private final Shell shell;
    private final String[] preparedCommand;
    private final Process process;

    RunningProcess(Shell shell, String[] preparedCommand, Process process) {
        this.shell = shell;
        this.preparedCommand = preparedCommand;
        this.process = process;
    }

    public String[] getPreparedCommand() {
        return this.preparedCommand;
    }

    public String getSplicedPreparedCommand() {
        return CommandTransform.splice(this.preparedCommand);
    }

    public RunningProcess echo(Sink sink) {
        return this.echo(sink, this.shell.getDefaultEcho());
    }

    public RunningProcess echo(Sink sink, CommandTransform commandTransform) {
        sink.accept((String)commandTransform.apply(this.getPreparedCommand()));
        sink.accept("\n");
        return this;
    }

    public RunningProcess pipeTo(Sink sink) {
        try (InputStream in = this.process.getInputStream();){
            RunningProcess.readStream(in, sink);
        }
        catch (IOException e) {
            throw new ProcessException("Error reading stdout", e);
        }
        return this;
    }

    private static String readStream(InputStream is, Consumer<String> sink) throws IOException {
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            int n;
            while ((n = reader.read(buffer)) != -1) {
                String output = new String(buffer, 0, n);
                ((Writer)writer).write(buffer, 0, n);
                sink.accept(output);
            }
        }
        return ((Object)writer).toString();
    }

    public int await() {
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    public int await(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            long started = System.currentTimeMillis();
            boolean completed = this.process.waitFor(timeout, unit);
            long took = System.currentTimeMillis() - started;
            if (!completed) {
                throw new TimeoutException(String.format("Process is still alive after %,d ms", took));
            }
            return this.process.exitValue();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    public Process getProcess() {
        return this.process;
    }
}

