/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.shell;

import com.obsidiandynamics.shell.NotInstalledError;
import com.obsidiandynamics.shell.ProcessException;
import com.obsidiandynamics.shell.ProcessExecutor;
import com.obsidiandynamics.shell.RunningProcess;
import com.obsidiandynamics.shell.Shell;
import java.io.IOException;
import java.util.Arrays;

public final class ShellBuilder {
    private Shell shell = Shell.getDefault();
    private ProcessExecutor executor = ProcessExecutor.getDefault();

    ShellBuilder() {
    }

    public ShellBuilder withShell(Shell shell) {
        this.shell = shell;
        return this;
    }

    public ShellBuilder withExecutor(ProcessExecutor executor) {
        this.executor = executor;
        return this;
    }

    public RunningProcess execute(String ... command) {
        Process process;
        String[] preparedCommand = this.shell.prepare(command);
        try {
            process = this.executor.run(preparedCommand);
            if (process == null) {
                throw new IllegalStateException("Executor returned a null process");
            }
        }
        catch (IOException e) {
            throw new ProcessException("Error executing prepared command " + Arrays.asList(preparedCommand), e);
        }
        return new RunningProcess(this.shell, preparedCommand, process);
    }

    public void checkInstalled(String ... command) {
        int exitCode = this.execute(command).await();
        if (exitCode != 0) {
            throw new NotInstalledError("Command " + Arrays.asList(command) + " exited with code " + exitCode);
        }
    }
}

