/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.threads;

import com.obsidiandynamics.func.Functions;

public final class Chrono {
    public static final long NANOS_IN_MICROSECOND = 1000L;
    public static final long NANOS_IN_MILLISECOND = 1000000L;
    public static final long NANOS_IN_SECOND = 1000000000L;
    private static final long DEF_SLEEP_GRANULARITY = 5000000L;
    private static final long DEF_YIELD_GRANULARITY = 5000L;
    private static final Chrono DEFAULT = new Chrono(5000000L, 5000L);
    private final long sleepGranularity;
    private final long yieldGranularity;

    public static Chrono getDefault() {
        return DEFAULT;
    }

    public Chrono(long sleepGranularityNanos, long yieldGranularityNanos) {
        this.sleepGranularity = sleepGranularityNanos;
        this.yieldGranularity = yieldGranularityNanos;
    }

    public long getSleepGranularity() {
        return this.sleepGranularity;
    }

    public long getYieldGranularity() {
        return this.yieldGranularity;
    }

    public void parkSeconds(double seconds) throws InterruptedException {
        Chrono.parkSeconds(seconds, this.sleepGranularity, this.yieldGranularity);
    }

    public void parkNanos(long nanos) throws InterruptedException {
        Chrono.parkNanos(nanos, this.sleepGranularity, this.yieldGranularity);
    }

    public static void parkSeconds(double seconds, long sleepGranularityNanos, long yieldGranularityNanos) throws InterruptedException {
        Chrono.parkNanos((long)(seconds * 1.0E9), sleepGranularityNanos, yieldGranularityNanos);
    }

    public static void parkNanos(long nanos, long sleepGranularityNanos, long yieldGranularityNanos) throws InterruptedException {
        long wakeTime = System.nanoTime() + nanos;
        while (true) {
            Functions.mustBeFalse((boolean)Thread.interrupted(), InterruptedException::new);
            long remainingNanos = wakeTime - System.nanoTime();
            if (remainingNanos >= 2L * sleepGranularityNanos) {
                long sleepMillis = Chrono.round(remainingNanos - sleepGranularityNanos, sleepGranularityNanos) / 1000000L;
                Thread.sleep(sleepMillis);
                continue;
            }
            if (remainingNanos >= 2L * yieldGranularityNanos) {
                Thread.yield();
                continue;
            }
            if (remainingNanos <= 0L) break;
        }
    }

    private static long round(long amount, long mod) {
        long remainder = amount % mod;
        return amount - remainder;
    }

    public String toString() {
        return Chrono.class.getSimpleName() + " [sleepGranularity=" + this.sleepGranularity + ", yieldGranularity=" + this.yieldGranularity + "]";
    }
}

