/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.threads;

import com.obsidiandynamics.func.Classes;
import com.obsidiandynamics.func.Functions;
import com.obsidiandynamics.threads.Striped;
import java.util.function.Supplier;

public final class EagerStriped<S>
implements Striped<S> {
    private final Object[] values;

    public EagerStriped(int stripes, Supplier<? extends S> valueSupplier) {
        Functions.mustExist(valueSupplier, (String)"Value supplier cannot be null");
        Functions.mustBeGreaterOrEqual((int)stripes, (int)0, (Supplier)Functions.illegalArgument((String)"Number of stripes cannot be negative"));
        this.values = new Object[stripes];
        for (int stripe = 0; stripe < stripes; ++stripe) {
            this.values[stripe] = valueSupplier.get();
        }
    }

    @Override
    public S get(int keyHash) {
        int stripe = Striped.resolveStripe(keyHash, this.values.length);
        return (S)Classes.cast((Object)this.values[stripe]);
    }
}

