/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.threads;

import com.obsidiandynamics.func.CheckedSupplier;

public class LazyReference<T, X extends Throwable> {
    private CheckedSupplier<T, X> supplier;
    private final Object lock = new Object();
    private volatile T reference;

    protected LazyReference(CheckedSupplier<T, X> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() throws X {
        T firstCheck = this.reference;
        if (firstCheck != null) {
            return firstCheck;
        }
        Object object = this.lock;
        synchronized (object) {
            T secondCheck = this.reference;
            if (secondCheck != null) {
                return secondCheck;
            }
            Object created = this.supplier.get();
            this.supplier = null;
            this.reference = created;
            return (T)created;
        }
    }

    public T peek() {
        return this.reference;
    }

    public String toString() {
        return LazyReference.class + " [reference=" + this.reference + "]";
    }

    public static <T, X extends Throwable> LazyReference<T, X> from(CheckedSupplier<T, X> supplier) {
        return new LazyReference<T, X>(supplier);
    }
}

