/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.threads;

import com.obsidiandynamics.func.Functions;
import com.obsidiandynamics.threads.Striped;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;

public final class LazyStriped<S>
implements Striped<S> {
    private final Supplier<? extends S> valueSupplier;
    private final AtomicReferenceArray<S> refArray;

    public LazyStriped(int stripes, Supplier<? extends S> valueSupplier) {
        this.valueSupplier = (Supplier)Functions.mustExist(valueSupplier, (String)"Value supplier cannot be null");
        Functions.mustBeGreaterOrEqual((int)stripes, (int)0, (Supplier)Functions.illegalArgument((String)"Number of stripes cannot be negative"));
        this.refArray = new AtomicReferenceArray(stripes);
    }

    @Override
    public S get(int keyHash) {
        int stripe = Striped.resolveStripe(keyHash, this.refArray.length());
        S existing = this.refArray.get(stripe);
        if (existing != null) {
            return existing;
        }
        S newValue = this.valueSupplier.get();
        if (this.refArray.compareAndSet(stripe, null, newValue)) {
            return newValue;
        }
        return this.refArray.get(stripe);
    }
}

