/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.threads;

import com.obsidiandynamics.threads.Threads;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public final class Parallel
implements Runnable {
    private static final boolean BLOCKING = true;
    private static final boolean NON_BLOCKING = false;
    private final CountDownLatch latch;
    private final CyclicBarrier barrier;

    private Parallel(CountDownLatch latch, CyclicBarrier barrier) {
        this.latch = latch;
        this.barrier = barrier;
    }

    public static Parallel blocking(int threads, IntConsumer r) {
        return Parallel.create(threads, true, r);
    }

    public static Parallel nonBlocking(int threads, IntConsumer r) {
        return Parallel.create(threads, false, r);
    }

    private static Parallel create(int threads, boolean blocking, IntConsumer r) {
        CountDownLatch latch = blocking ? new CountDownLatch(threads) : null;
        CyclicBarrier barrier = new CyclicBarrier(threads + 1);
        String threadNameFormat = "ParRunner-%0" + Parallel.numDigits(threads) + "d";
        for (int i = 0; i < threads; ++i) {
            int _i = i;
            Thread t = new Thread(() -> {
                Threads.await(barrier);
                try {
                    r.accept(_i);
                }
                finally {
                    if (latch != null) {
                        latch.countDown();
                    }
                }
            }, String.format(threadNameFormat, i));
            t.start();
        }
        return new Parallel(latch, barrier);
    }

    private static int numDigits(int num) {
        return String.valueOf(num).length();
    }

    public static <T> Parallel blockingSlice(List<T> list, int threads, Consumer<List<T>> task) {
        return Parallel.slice(list, threads, true, task);
    }

    public static <T> Parallel nonBlockingSlice(List<T> list, int threads, Consumer<List<T>> task) {
        return Parallel.slice(list, threads, false, task);
    }

    static <T> List<List<T>> split(List<T> list, int ways) {
        if (ways < 1 || ways > list.size()) {
            throw new IllegalArgumentException("Number of ways must be between 1 and " + list.size() + " (inclusive)");
        }
        ArrayList<List<T>> lists = new ArrayList<List<T>>(ways);
        int pos = 0;
        for (int i = 0; i < ways; ++i) {
            int remaining = ways - i;
            int len = (list.size() - pos) / remaining;
            lists.add(list.subList(pos, pos + len));
            pos += len;
        }
        return lists;
    }

    private static <T> Parallel slice(List<T> list, int threads, boolean blocking, Consumer<List<T>> task) {
        int actualThreads = Math.min(threads, list.size());
        List lists = Parallel.split(list, actualThreads);
        return Parallel.create(actualThreads, blocking, i -> {
            List sublist = (List)lists.get(i);
            task.accept(sublist);
        });
    }

    @Override
    public void run() {
        Threads.await(this.barrier);
        if (this.latch != null) {
            Threads.await(this.latch);
        }
    }
}

