/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.threads;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public final class ReferenceCountingMap<K, V> {
    private static final int DEF_CAPACITY = 16;
    private static final float DEF_LOAD_FACTOR = 0.75f;
    private static final int DEF_CONCURRENCY_LEVEL = 16;
    private final Map<K, Slot<V>> map;

    public ReferenceCountingMap() {
        this(16, 0.75f, 16);
    }

    public ReferenceCountingMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.map = new ConcurrentHashMap<K, Slot<V>>(initialCapacity, loadFactor, concurrencyLevel);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public V tryScope(K key) {
        Slot slot = this.map.computeIfPresent(key, (__, existingSlot) -> {
            ((Slot)existingSlot).uses++;
            return existingSlot;
        });
        return (V)(slot != null ? slot.value : null);
    }

    public V scope(K key, Supplier<? extends V> valueMaker) {
        return (V)this.map.compute(key, (__, existingSlot) -> {
            if (existingSlot != null) {
                ((Slot)existingSlot).uses++;
                return existingSlot;
            }
            return new Slot(valueMaker.get());
        }).value;
    }

    public void descope(K key) {
        this.map.computeIfPresent(key, (__, existingSlot) -> {
            ((Slot)existingSlot).uses--;
            return ((Slot)existingSlot).uses == 0 ? null : existingSlot;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (K key : this.map.keySet()) {
            V value = this.tryScope(key);
            if (value == null) continue;
            try {
                action.accept(key, value);
            }
            finally {
                this.descope(key);
            }
        }
    }

    public String toString() {
        return ReferenceCountingMap.class.getSimpleName() + " [keySet=" + this.keySet() + "]";
    }

    private static final class Slot<V> {
        private final V value;
        private int uses = 1;

        Slot(V value) {
            this.value = value;
        }
    }
}

