/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.threads;

import com.obsidiandynamics.func.CheckedBooleanSupplier;
import com.obsidiandynamics.func.CheckedRunnable;
import com.obsidiandynamics.func.CheckedSupplier;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;

public final class Threads {
    private Threads() {
    }

    public static boolean sleep(long millis) {
        if (millis > 0L) {
            return Threads.deferInterrupt((CheckedRunnable<InterruptedException>)((CheckedRunnable)() -> Thread.sleep(millis)));
        }
        return !Thread.currentThread().isInterrupted();
    }

    public static boolean deferInterrupt(CheckedRunnable<InterruptedException> interruptible) {
        try {
            interruptible.run();
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static boolean deferInterrupt(CheckedBooleanSupplier<InterruptedException> interruptible, boolean onInterrupt) {
        try {
            return interruptible.getAsBoolean();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return onInterrupt;
        }
    }

    public static <T> T deferInterrupt(CheckedSupplier<? extends T, InterruptedException> interruptible, T onInterrupt) {
        try {
            return (T)interruptible.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return onInterrupt;
        }
    }

    public static int suppressInterrupts(CheckedRunnable<InterruptedException> interruptible) {
        boolean interrupted = false;
        int attempts = 1;
        while (true) {
            try {
                interruptible.run();
            }
            catch (InterruptedException e) {
                interrupted = true;
                ++attempts;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return attempts;
    }

    public static <T> T suppressInterrupts(CheckedSupplier<? extends T, InterruptedException> interruptible) {
        boolean interrupted = false;
        while (true) {
            try {
                Object object = interruptible.get();
                return (T)object;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean await(CountDownLatch latch) {
        return Threads.deferInterrupt((CheckedRunnable<InterruptedException>)((CheckedRunnable)latch::await));
    }

    public static boolean await(CyclicBarrier barrier) {
        return Threads.deferInterrupt((CheckedRunnable<InterruptedException>)((CheckedRunnable)() -> {
            try {
                barrier.await();
            }
            catch (BrokenBarrierException e) {
                throw new RuntimeBrokenBarrierException(e);
            }
        }));
    }

    public static <X extends Throwable> long tookMillis(CheckedRunnable<X> r) throws X {
        return Threads.tookNanos(r) / 1000000L;
    }

    public static <X extends Throwable> long tookNanos(CheckedRunnable<X> r) throws X {
        long started = System.nanoTime();
        r.run();
        return System.nanoTime() - started;
    }

    public static final class RuntimeBrokenBarrierException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        RuntimeBrokenBarrierException(Throwable cause) {
            super(cause);
        }
    }
}

