/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.version;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public final class AppVersion {
    private AppVersion() {
    }

    public static String get(String appName) throws IOException {
        return AppVersion.get(appName, new Constant("0"));
    }

    public static String get(String appName, DefaultValueSupplier buildstampDefaultValueSupplier) throws IOException {
        return AppVersion.getFile(appName + ".version") + "_" + AppVersion.getFile(appName + ".build", buildstampDefaultValueSupplier);
    }

    static String getFile(String file) throws IOException {
        return AppVersion.getFile(file, () -> {
            throw new FileNotFoundException("Not found: " + file);
        });
    }

    static String getFile(String file, DefaultValueSupplier defaultValueSupplier) throws IOException {
        return AppVersion.readResourceHead(file, defaultValueSupplier);
    }

    private static String readResourceHead(String file, DefaultValueSupplier defaultValueSupplier) throws IOException {
        URL url = AppVersion.class.getClassLoader().getResource(file);
        if (url == null) {
            return defaultValueSupplier.get();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line = reader.readLine();
            if (line != null) {
                String string = line.trim();
                return string;
            }
            throw new EOFException();
        }
    }

    public static final class Constant
    implements DefaultValueSupplier {
        private final String def;

        Constant(String def) {
            this.def = def;
        }

        @Override
        public String get() throws FileNotFoundException {
            return this.def;
        }
    }

    @FunctionalInterface
    public static interface DefaultValueSupplier {
        public String get() throws IOException;
    }
}

