/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.meteor.util;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IFunction;
import com.hazelcast.ringbuffer.OverflowPolicy;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.obsidiandynamics.retry.Retry;
import java.util.Collection;

public final class RetryableRingbuffer<E> {
    private final Retry retry;
    private final Ringbuffer<E> ringbuffer;

    public RetryableRingbuffer(Retry retry, Ringbuffer<E> ringbuffer) {
        this.retry = retry;
        this.ringbuffer = ringbuffer;
    }

    public Ringbuffer<E> getRingbuffer() {
        return this.ringbuffer;
    }

    public ICompletableFuture<Long> addAllAsync(Collection<? extends E> collection, OverflowPolicy overflowPolicy) {
        return (ICompletableFuture)this.retry.run(() -> this.ringbuffer.addAllAsync(collection, overflowPolicy));
    }

    public long add(E item) {
        return (Long)this.retry.run(() -> this.ringbuffer.add(item));
    }

    public ICompletableFuture<ReadResultSet<E>> readManyAsync(long startSequence, int minCount, int maxCount, IFunction<E, Boolean> filter) {
        return (ICompletableFuture)this.retry.run(() -> this.ringbuffer.readManyAsync(startSequence, minCount, maxCount, filter));
    }

    public long tailSequence() {
        return (Long)this.retry.run(() -> this.ringbuffer.tailSequence());
    }
}

