/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.zerolog;

import com.obsidiandynamics.zerolog.ConfigService;
import com.obsidiandynamics.zerolog.ConfigServiceDefaults;
import com.obsidiandynamics.zerolog.ZlgFactory;

public final class HazelcastZlgBridge {
    private static final String PROPERTY_KEY = "hazelcast.logging.class";
    private static final String factoryClass = ZlgFactory.class.getName();

    public static boolean isInstalled() {
        return factoryClass.equals(System.getProperty(PROPERTY_KEY));
    }

    public static void install() {
        HazelcastZlgBridge.install(ConfigServiceDefaults.getDefaultConfigService());
    }

    public static void install(ConfigService configService) {
        ZlgFactory.setConfigService(configService);
        System.setProperty(PROPERTY_KEY, factoryClass);
    }

    public static void uninstall() {
        if (HazelcastZlgBridge.isInstalled()) {
            System.getProperties().remove(PROPERTY_KEY);
            ZlgFactory.setConfigService(ConfigServiceDefaults.getDefaultConfigService());
        }
    }

    private HazelcastZlgBridge() {
    }
}

