/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.zerolog;

import java.util.function.IntPredicate;
import java.util.logging.Level;

final class JulMappings {
    private static final LevelMapping[] defaultMappings = new LevelMapping[9];

    static LevelMapping[] getDefaultMappings() {
        return defaultMappings;
    }

    static int mapLevel(Level level) {
        int intValue = level.intValue();
        if (intValue <= Level.FINER.intValue()) {
            return 256;
        }
        if (intValue <= Level.FINE.intValue()) {
            return 512;
        }
        if (intValue <= Level.CONFIG.intValue()) {
            return 768;
        }
        if (intValue <= Level.INFO.intValue()) {
            return 1024;
        }
        if (intValue <= Level.WARNING.intValue()) {
            return 1280;
        }
        if (intValue <= Level.SEVERE.intValue()) {
            return 1536;
        }
        return 1792;
    }

    static Level findFirst(LevelMapping[] mappings, IntPredicate predicate) {
        for (LevelMapping mapping : mappings) {
            if (!predicate.test(mapping.zlgLevel)) continue;
            return mapping.julLevel;
        }
        throw new IllegalStateException("No matching level found");
    }

    private JulMappings() {
    }

    static {
        int i = 0;
        for (Level level : new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF}) {
            JulMappings.defaultMappings[i++] = new LevelMapping(level, JulMappings.mapLevel(level));
        }
    }

    static final class LevelMapping {
        final Level julLevel;
        final int zlgLevel;

        LevelMapping(Level julLevel, int zlgLevel) {
            this.julLevel = julLevel;
            this.zlgLevel = zlgLevel;
        }
    }
}

