/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.zerolog;

import com.obsidiandynamics.zerolog.Zlg;
import com.obsidiandynamics.zerolog.ZlgHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class JulZlgBridge {
    private static final Set<Handler> handlerStash = new HashSet<Handler>();

    public static boolean isInstalled() {
        return Arrays.stream(JulZlgBridge.getRootLogger().getHandlers()).anyMatch(ZlgHandler.class::isInstance);
    }

    public static void install(Zlg zlg) {
        JulZlgBridge.getRootLogger().addHandler(new ZlgHandler(zlg));
    }

    public static void installAllHandlers(Set<Handler> handlers) {
        Logger root = JulZlgBridge.getRootLogger();
        handlers.forEach(root::addHandler);
    }

    public static void uninstall() {
        Logger root = JulZlgBridge.getRootLogger();
        Arrays.stream(root.getHandlers()).filter(ZlgHandler.class::isInstance).forEach(root::removeHandler);
    }

    public static Set<Handler> uninstallAllHandlers() {
        Logger root = JulZlgBridge.getRootLogger();
        HashSet<Handler> stash = new HashSet<Handler>(root.getHandlers().length, 1.0f);
        Arrays.stream(root.getHandlers()).forEach(handler -> {
            stash.add((Handler)handler);
            root.removeHandler((Handler)handler);
        });
        return stash;
    }

    public static void stashAllHandlers() {
        handlerStash.addAll(JulZlgBridge.uninstallAllHandlers());
    }

    public static void unstashAllHandlers() {
        JulZlgBridge.installAllHandlers(handlerStash);
        handlerStash.clear();
    }

    public static Logger getRootLogger() {
        return LogManager.getLogManager().getLogger("");
    }

    private JulZlgBridge() {
    }
}

