/*
 * Decompiled with CFR 0.152.
 */
package com.obsidiandynamics.zerolog;

import com.obsidiandynamics.format.SafeFormat;
import com.obsidiandynamics.zerolog.LogLevel;
import com.obsidiandynamics.zerolog.LogTarget;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

final class Slf4jLogTarget
implements LogTarget {
    private final boolean isLocationAware;
    private final Logger log;
    private final LogMapping[] mappings = new LogMapping[LogLevel.Enum.values().length];
    private static final Object[] noArgs = new Object[0];

    Slf4jLogTarget(Logger log) {
        this.log = log;
        this.isLocationAware = log instanceof LocationAwareLogger;
        for (LogLevel.Enum level : LogLevel.Enum.values()) {
            if (level.getLevel() == 1792) continue;
            this.mappings[level.ordinal()] = LogMapping.forLevel(log, level.getLevel());
        }
    }

    private LogMapping map(int level) {
        return (LogMapping)LogLevel.map((int)level, (Object[])this.mappings);
    }

    public boolean isEnabled(int level) {
        return this.map(level).logEnabled.isEnabled();
    }

    public void log(int level, String tag, String format, int argc, Object[] argv, Throwable throwable, String entrypoint) {
        if (this.isLocationAware) {
            this.logWithLocation(level, tag, format, argc, argv, throwable, entrypoint);
        } else {
            this.logDirect(level, tag, format, argc, argv, throwable);
        }
    }

    private void logDirect(int level, String tag, String format, int argc, Object[] argv, Throwable throwable) {
        LogMapping mapping = this.map(level);
        String message = SafeFormat.format((String)format, (int)argc, (Object[])argv);
        if (tag != null && throwable != null) {
            Marker marker = MarkerFactory.getMarker((String)tag);
            mapping.logMarkerMessageThrowable.log(marker, message, throwable);
        } else if (tag != null) {
            Marker marker = MarkerFactory.getMarker((String)tag);
            mapping.logMarkerMessage.log(marker, message);
        } else if (throwable != null) {
            mapping.logMessageThrowable.log(message, throwable);
        } else {
            mapping.logMessage.log(message);
        }
    }

    private void logWithLocation(int level, String tag, String format, int argc, Object[] argv, Throwable throwable, String entrypoint) {
        Marker marker = tag != null ? MarkerFactory.getMarker((String)tag) : null;
        String message = SafeFormat.format((String)format, (int)argc, (Object[])argv);
        int intLevel = this.map(level).intLevel;
        ((LocationAwareLogger)this.log).log(marker, entrypoint, intLevel, message, noArgs, throwable);
    }

    static final class LogMapping {
        private final int intLevel;
        private final LogEnabled logEnabled;
        private final LogMessage logMessage;
        private final LogMarkerMessage logMarkerMessage;
        private final LogMessageThrowable logMessageThrowable;
        private final LogMarkerMessageThrowable logMarkerMessageThrowable;

        private LogMapping(int intLevel, LogEnabled logEnabled, LogMessage logMessage, LogMarkerMessage logMarkerMessage, LogMessageThrowable logMessageThrowable, LogMarkerMessageThrowable logMarkerMessageThrowable) {
            this.intLevel = intLevel;
            this.logEnabled = logEnabled;
            this.logMessage = logMessage;
            this.logMarkerMessage = logMarkerMessage;
            this.logMessageThrowable = logMessageThrowable;
            this.logMarkerMessageThrowable = logMarkerMessageThrowable;
        }

        static LogMapping forLevel(Logger log, int level) {
            switch (level) {
                case 1536: {
                    return new LogMapping(40, () -> ((Logger)log).isErrorEnabled(), arg_0 -> ((Logger)log).error(arg_0), (arg_0, arg_1) -> ((Logger)log).error(arg_0, arg_1), (arg_0, arg_1) -> ((Logger)log).error(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((Logger)log).error(arg_0, arg_1, arg_2));
                }
                case 1280: {
                    return new LogMapping(30, () -> ((Logger)log).isWarnEnabled(), arg_0 -> ((Logger)log).warn(arg_0), (arg_0, arg_1) -> ((Logger)log).warn(arg_0, arg_1), (arg_0, arg_1) -> ((Logger)log).warn(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((Logger)log).warn(arg_0, arg_1, arg_2));
                }
                case 768: 
                case 1024: {
                    return new LogMapping(20, () -> ((Logger)log).isInfoEnabled(), arg_0 -> ((Logger)log).info(arg_0), (arg_0, arg_1) -> ((Logger)log).info(arg_0, arg_1), (arg_0, arg_1) -> ((Logger)log).info(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((Logger)log).info(arg_0, arg_1, arg_2));
                }
                case 512: {
                    return new LogMapping(10, () -> ((Logger)log).isDebugEnabled(), arg_0 -> ((Logger)log).debug(arg_0), (arg_0, arg_1) -> ((Logger)log).debug(arg_0, arg_1), (arg_0, arg_1) -> ((Logger)log).debug(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((Logger)log).debug(arg_0, arg_1, arg_2));
                }
                case 256: {
                    return new LogMapping(0, () -> ((Logger)log).isTraceEnabled(), arg_0 -> ((Logger)log).trace(arg_0), (arg_0, arg_1) -> ((Logger)log).trace(arg_0, arg_1), (arg_0, arg_1) -> ((Logger)log).trace(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((Logger)log).trace(arg_0, arg_1, arg_2));
                }
            }
            throw new UnsupportedOperationException("Unsupported level " + level);
        }
    }

    @FunctionalInterface
    private static interface LogEnabled {
        public boolean isEnabled();
    }

    @FunctionalInterface
    private static interface LogMarkerMessageThrowable {
        public void log(Marker var1, String var2, Throwable var3);
    }

    @FunctionalInterface
    private static interface LogMarkerMessage {
        public void log(Marker var1, String var2);
    }

    @FunctionalInterface
    private static interface LogMessageThrowable {
        public void log(String var1, Throwable var2);
    }

    @FunctionalInterface
    private static interface LogMessage {
        public void log(String var1);
    }
}

