/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.configure;

import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.util.EncryptUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;

public class DataSourceInfo {
    private DataBaseType databaseType = DataBaseType.UNKNOWN;
    private String rsUrl = null;
    private String jdbcUrl = null;
    private String databaseName = null;
    private String fullUserName = null;
    private String password = null;
    private String connectionProperties = "rewriteBatchedStatements=true;connectTimeout=2000;GetConnectionTimeout=2000;allowMultiQueries=true;useLocalSessionState=true;yearIsDateType=false;";
    private int connectionCount = 1;
    private int rateLimit = -1;
    private boolean encrypt = false;
    private String ip = "";
    private int port = 3306;
    private int sleepTime = 50;
    private int cpuLimit = 25;
    private int queryTimeout = 25;
    private long clusterId = -1L;
    private String dataSourceName = null;
    private String obProxy = null;
    private String sysUser = "";
    private String sysPassword = null;
    private String sysDatabaseName = "";
    private Long tenantId = null;
    private String clusterName = null;
    private String tenantName = null;

    public String getEncryptSysPassword() throws NoSuchPaddingException, IllegalBlockSizeException, UnsupportedEncodingException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        if (this.sysPassword != null) {
            return EncryptUtils.decode(this.sysPassword);
        }
        return null;
    }

    public String getSysFullUserName() {
        if (StringUtils.isEmpty((String)this.fullUserName)) {
            return "";
        }
        return String.format("%s:%s:%s", this.clusterName, "sys", this.sysUser);
    }

    public DataBaseType getDatabaseType() {
        return this.databaseType;
    }

    public String getRsUrl() {
        return this.rsUrl;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getFullUserName() {
        return this.fullUserName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public int getRateLimit() {
        return this.rateLimit;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public int getCpuLimit() {
        return this.cpuLimit;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getObProxy() {
        return this.obProxy;
    }

    public String getSysUser() {
        return this.sysUser;
    }

    public String getSysPassword() {
        return this.sysPassword;
    }

    public String getSysDatabaseName() {
        return this.sysDatabaseName;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setDatabaseType(DataBaseType databaseType) {
        this.databaseType = databaseType;
    }

    public void setRsUrl(String rsUrl) {
        this.rsUrl = rsUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setFullUserName(String fullUserName) {
        this.fullUserName = fullUserName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConnectionProperties(String connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void setConnectionCount(int connectionCount) {
        this.connectionCount = connectionCount;
    }

    public void setRateLimit(int rateLimit) {
        this.rateLimit = rateLimit;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setCpuLimit(int cpuLimit) {
        this.cpuLimit = cpuLimit;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setClusterId(long clusterId) {
        this.clusterId = clusterId;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setObProxy(String obProxy) {
        this.obProxy = obProxy;
    }

    public void setSysUser(String sysUser) {
        this.sysUser = sysUser;
    }

    public void setSysPassword(String sysPassword) {
        this.sysPassword = sysPassword;
    }

    public void setSysDatabaseName(String sysDatabaseName) {
        this.sysDatabaseName = sysDatabaseName;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceInfo)) {
            return false;
        }
        DataSourceInfo other = (DataSourceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataBaseType this$databaseType = this.getDatabaseType();
        DataBaseType other$databaseType = other.getDatabaseType();
        if (this$databaseType == null ? other$databaseType != null : !((Object)((Object)this$databaseType)).equals((Object)other$databaseType)) {
            return false;
        }
        String this$rsUrl = this.getRsUrl();
        String other$rsUrl = other.getRsUrl();
        if (this$rsUrl == null ? other$rsUrl != null : !this$rsUrl.equals(other$rsUrl)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$fullUserName = this.getFullUserName();
        String other$fullUserName = other.getFullUserName();
        if (this$fullUserName == null ? other$fullUserName != null : !this$fullUserName.equals(other$fullUserName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$connectionProperties = this.getConnectionProperties();
        String other$connectionProperties = other.getConnectionProperties();
        if (this$connectionProperties == null ? other$connectionProperties != null : !this$connectionProperties.equals(other$connectionProperties)) {
            return false;
        }
        if (this.getConnectionCount() != other.getConnectionCount()) {
            return false;
        }
        if (this.getRateLimit() != other.getRateLimit()) {
            return false;
        }
        if (this.isEncrypt() != other.isEncrypt()) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getSleepTime() != other.getSleepTime()) {
            return false;
        }
        if (this.getCpuLimit() != other.getCpuLimit()) {
            return false;
        }
        if (this.getQueryTimeout() != other.getQueryTimeout()) {
            return false;
        }
        if (this.getClusterId() != other.getClusterId()) {
            return false;
        }
        String this$dataSourceName = this.getDataSourceName();
        String other$dataSourceName = other.getDataSourceName();
        if (this$dataSourceName == null ? other$dataSourceName != null : !this$dataSourceName.equals(other$dataSourceName)) {
            return false;
        }
        String this$obProxy = this.getObProxy();
        String other$obProxy = other.getObProxy();
        if (this$obProxy == null ? other$obProxy != null : !this$obProxy.equals(other$obProxy)) {
            return false;
        }
        String this$sysUser = this.getSysUser();
        String other$sysUser = other.getSysUser();
        if (this$sysUser == null ? other$sysUser != null : !this$sysUser.equals(other$sysUser)) {
            return false;
        }
        String this$sysPassword = this.getSysPassword();
        String other$sysPassword = other.getSysPassword();
        if (this$sysPassword == null ? other$sysPassword != null : !this$sysPassword.equals(other$sysPassword)) {
            return false;
        }
        String this$sysDatabaseName = this.getSysDatabaseName();
        String other$sysDatabaseName = other.getSysDatabaseName();
        if (this$sysDatabaseName == null ? other$sysDatabaseName != null : !this$sysDatabaseName.equals(other$sysDatabaseName)) {
            return false;
        }
        Long this$tenantId = this.getTenantId();
        Long other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$tenantName = this.getTenantName();
        String other$tenantName = other.getTenantName();
        return !(this$tenantName == null ? other$tenantName != null : !this$tenantName.equals(other$tenantName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataBaseType $databaseType = this.getDatabaseType();
        result = result * 59 + ($databaseType == null ? 43 : ((Object)((Object)$databaseType)).hashCode());
        String $rsUrl = this.getRsUrl();
        result = result * 59 + ($rsUrl == null ? 43 : $rsUrl.hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $fullUserName = this.getFullUserName();
        result = result * 59 + ($fullUserName == null ? 43 : $fullUserName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $connectionProperties = this.getConnectionProperties();
        result = result * 59 + ($connectionProperties == null ? 43 : $connectionProperties.hashCode());
        result = result * 59 + this.getConnectionCount();
        result = result * 59 + this.getRateLimit();
        result = result * 59 + (this.isEncrypt() ? 79 : 97);
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + this.getSleepTime();
        result = result * 59 + this.getCpuLimit();
        result = result * 59 + this.getQueryTimeout();
        long $clusterId = this.getClusterId();
        result = result * 59 + (int)($clusterId >>> 32 ^ $clusterId);
        String $dataSourceName = this.getDataSourceName();
        result = result * 59 + ($dataSourceName == null ? 43 : $dataSourceName.hashCode());
        String $obProxy = this.getObProxy();
        result = result * 59 + ($obProxy == null ? 43 : $obProxy.hashCode());
        String $sysUser = this.getSysUser();
        result = result * 59 + ($sysUser == null ? 43 : $sysUser.hashCode());
        String $sysPassword = this.getSysPassword();
        result = result * 59 + ($sysPassword == null ? 43 : $sysPassword.hashCode());
        String $sysDatabaseName = this.getSysDatabaseName();
        result = result * 59 + ($sysDatabaseName == null ? 43 : $sysDatabaseName.hashCode());
        Long $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $tenantName = this.getTenantName();
        result = result * 59 + ($tenantName == null ? 43 : $tenantName.hashCode());
        return result;
    }

    public String toString() {
        return "DataSourceInfo(databaseType=" + (Object)((Object)this.getDatabaseType()) + ", rsUrl=" + this.getRsUrl() + ", jdbcUrl=" + this.getJdbcUrl() + ", databaseName=" + this.getDatabaseName() + ", fullUserName=" + this.getFullUserName() + ", password=" + this.getPassword() + ", connectionProperties=" + this.getConnectionProperties() + ", connectionCount=" + this.getConnectionCount() + ", rateLimit=" + this.getRateLimit() + ", encrypt=" + this.isEncrypt() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", sleepTime=" + this.getSleepTime() + ", cpuLimit=" + this.getCpuLimit() + ", queryTimeout=" + this.getQueryTimeout() + ", clusterId=" + this.getClusterId() + ", dataSourceName=" + this.getDataSourceName() + ", obProxy=" + this.getObProxy() + ", sysUser=" + this.getSysUser() + ", sysPassword=" + this.getSysPassword() + ", sysDatabaseName=" + this.getSysDatabaseName() + ", tenantId=" + this.getTenantId() + ", clusterName=" + this.getClusterName() + ", tenantName=" + this.getTenantName() + ")";
    }
}

