/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.util;

import com.oceanbase.tools.migrator.common.configure.LogicTableConfig;
import com.oceanbase.tools.migrator.common.enums.PrimaryKeyChoice;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.handler.AbstractReadHandler;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class OBMySQLTableUtils {
    public static void initShardKeyColumns(Connection conn, TableMeta tableMeta) throws SQLException {
        List shardKeyColumns;
        String shardKeyName;
        TreeMap<String, 1> indexName2Columns = new TreeMap<String, 1>();
        String querySql = String.format("SELECT INDEX_NAME,GROUP_CONCAT(COLUMN_NAME ORDER BY SEQ_IN_INDEX SEPARATOR ',') AS UK_INDEX_COLUMNS FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s' AND NON_UNIQUE = 0 AND NULLABLE != 'YES' GROUP BY INDEX_NAME", tableMeta.getSchema(), tableMeta.getName());
        try (Statement statement = conn.createStatement();){
            ResultSet resultSet = statement.executeQuery(querySql);
            while (resultSet.next()) {
                String indexName = resultSet.getString("INDEX_NAME");
                final String ukColumnName = resultSet.getString("UK_INDEX_COLUMNS");
                indexName2Columns.put(indexName, new ArrayList<String>(){
                    {
                        this.addAll(Arrays.asList(StringUtils.split((String)ukColumnName, (String)",")));
                    }
                });
            }
        }
        if (indexName2Columns.isEmpty()) {
            throw new UnExpectedException("tableUniqueIndexColumns is empty");
        }
        if (indexName2Columns.containsKey("PRIMARY")) {
            shardKeyName = "PRIMARY";
            shardKeyColumns = (List)indexName2Columns.get("PRIMARY");
        } else {
            Map.Entry firstEntry = indexName2Columns.firstEntry();
            shardKeyName = (String)firstEntry.getKey();
            shardKeyColumns = (List)firstEntry.getValue();
        }
        tableMeta.setShardKeyName(shardKeyName);
        LinkedList<ColumnMeta> shardKeyColumnMetas = new LinkedList<ColumnMeta>();
        for (int i = 0; i < shardKeyColumns.size(); ++i) {
            ColumnMeta columnMeta = tableMeta.getColumnMetaMap().get(shardKeyColumns.get(i));
            columnMeta.setShardKeyIndex(i);
            shardKeyColumnMetas.add(columnMeta);
        }
        tableMeta.setShardKeyColumns(shardKeyColumnMetas);
    }

    public static TreeMap<String, List<String>> getTableUniqueKeyColumns(Connection conn, String schemaName, String tableName) throws SQLException {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
        String querySql = String.format("SELECT INDEX_NAME,GROUP_CONCAT(COLUMN_NAME ORDER BY SEQ_IN_INDEX SEPARATOR ',') AS UK_INDEX_COLUMNSFROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s' AND NON_UNIQUE = 0 AND NULLABLE != 'YES' GROUP BY INDEX_NAME", schemaName, tableName);
        try (Statement statement = conn.createStatement();){
            ResultSet resultSet = statement.executeQuery(querySql);
            while (resultSet.next()) {
                String indexName = resultSet.getString("INDEX_NAME");
                final String ukColumnName = resultSet.getString("UK_INDEX_COLUMNS");
                result.put(indexName, (List<String>)new ArrayList<String>(){
                    {
                        this.addAll(Arrays.asList(StringUtils.split((String)ukColumnName, (String)",")));
                    }
                });
            }
        }
        return result;
    }

    public static boolean checkUniqueIndexColumns(TableMeta source, TableMeta target) {
        List<ColumnMeta> sourceTableUniqueKeyColumns = source.getShardKeyColumns();
        List<ColumnMeta> targetTableUniqueKeyColumns = target.getShardKeyColumns();
        if (sourceTableUniqueKeyColumns.size() != targetTableUniqueKeyColumns.size()) {
            return false;
        }
        for (int i = 0; i < sourceTableUniqueKeyColumns.size(); ++i) {
            if (sourceTableUniqueKeyColumns.get(i).getName().equalsIgnoreCase(targetTableUniqueKeyColumns.get(i).getName())) continue;
            return false;
        }
        return true;
    }

    private boolean useTargetTableMetaAsPrimary(final JobMeta jobMeta) throws SQLException {
        LogicTableConfig logicTableConfig = jobMeta.getLogicTableConfig();
        final DataSourceAdapter sourceAdapter = jobMeta.getSourceAdapter();
        final TableMeta targetTableMeta = jobMeta.getTargetTableMeta();
        final TableMeta sourceTableMeta = jobMeta.getSourceTableMeta();
        final DataSourceAdapter targetAdapter = jobMeta.getTargetAdapter();
        boolean ret = false;
        if (logicTableConfig != null && !OBMySQLTableUtils.checkUniqueIndexColumns(sourceTableMeta, targetTableMeta)) {
            if (logicTableConfig.getPrimaryKeyChoice() != null) {
                return logicTableConfig.getPrimaryKeyChoice() == PrimaryKeyChoice.USE_TARGET_PRIMARY;
            }
            ret = (Boolean)HandlerUtils.runWithSimpleRetry(new AbstractReadHandler(sourceAdapter){

                /*
                 * Exception decompiling
                 */
                @Override
                public Object run(Connection connection) throws SQLException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        return ret;
    }
}

