/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core;

import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.common.configure.JoinTableInfo;
import com.oceanbase.tools.migrator.common.configure.LogicTableConfig;
import com.oceanbase.tools.migrator.common.configure.SubTableInfo;
import com.oceanbase.tools.migrator.common.dto.HistoryJob;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.ColumnCountNotMatchException;
import com.oceanbase.tools.migrator.common.exception.DatasourceInitFailedException;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.exception.JobException;
import com.oceanbase.tools.migrator.common.exception.TableMetaInitException;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.common.meta.TableMetaManager;
import com.oceanbase.tools.migrator.core.AbstractJobMetaFactory;
import com.oceanbase.tools.migrator.core.JobReq;
import com.oceanbase.tools.migrator.core.handler.ClusterMetaHandle;
import com.oceanbase.tools.migrator.core.handler.LogicTableConfigHandle;
import com.oceanbase.tools.migrator.core.handler.TenantMetaHandle;
import com.oceanbase.tools.migrator.core.meta.ClusterMeta;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.meta.TenantMeta;
import com.oceanbase.tools.migrator.dao.HistoryJobDao;
import com.oceanbase.tools.migrator.framework.MainFramework;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMetaFactory
extends AbstractJobMetaFactory {
    private static final Logger log = LoggerFactory.getLogger(JobMetaFactory.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobMeta create(String jobId) throws JobException {
        try (Connection connection = MainFramework.getMetaDataSource().getConnection();){
            HistoryJob job = HistoryJobDao.queryJob(connection, jobId);
            LogicTableConfig logicTableConfig = LogicTableConfigHandle.getLogicTableConfig(job.getLogicTableId(), job.getShardingParametersMap(), job.getDateStart(), job.getDateEnd());
            ClusterMeta sourceCluster = ClusterMetaHandle.getClusterMeta(MainFramework.getDataSourceManager().getClusterId(job.getSourceDs()));
            ClusterMeta targetCluster = ClusterMetaHandle.getClusterMeta(MainFramework.getDataSourceManager().getClusterId(job.getTargetDs()));
            TenantMeta sourceTenant = TenantMetaHandle.getTenantMeta(MainFramework.getDataSourceManager().getTenantName(job.getSourceDs()));
            TenantMeta targetTenant = TenantMetaHandle.getTenantMeta(MainFramework.getDataSourceManager().getTenantName(job.getTargetDs()));
            DataSourceInfo sourceInfo = MainFramework.getDataSourceManager().getDataSourceInfo(job.getSourceDs());
            if (sourceInfo == null) {
                throw new DatasourceInitFailedException(jobId, "init dataSource failed, name = " + job.getSourceDs());
            }
            DataSourceInfo targetInfo = MainFramework.getDataSourceManager().getDataSourceInfo(job.getTargetDs());
            if (targetInfo == null) {
                throw new DatasourceInitFailedException(jobId, "init dataSource failed, name = " + job.getTargetDs());
            }
            JobReq req = new JobReq(job, logicTableConfig, sourceInfo, targetInfo, sourceCluster, targetCluster, sourceTenant, targetTenant);
            JobMeta jobMeta = super.create(req);
            this.initJoinTables(job.getTableId(), jobMeta);
            this.initSubTables(job.getTableId(), jobMeta);
            JobMeta jobMeta2 = jobMeta;
            return jobMeta2;
        }
        catch (Exception e) {
            throw new JobException(jobId, e.getMessage());
        }
    }

    @Override
    public void initTableMeta(JobMeta jobMeta, String srcTable, String targetTable, Long tableId) throws TableMetaInitException {
        try {
            super.initTableMeta(jobMeta, srcTable, targetTable, tableId);
            JobMetaFactory.checkTableSchema(jobMeta.getJobId(), jobMeta.getSourceTableMeta(), jobMeta.getTargetTableMeta());
        }
        catch (Exception e) {
            throw new TableMetaInitException(jobMeta.getJobId(), e);
        }
    }

    private static void checkTableSchema(String jobId, TableMeta sourceTableMeta, TableMeta targetTableMeta) throws ColumnCountNotMatchException {
        if (sourceTableMeta.getColumnMetas().size() != targetTableMeta.getColumnMetas().size()) {
            String errMsg = String.format("source column count = %d, target column count = %d", sourceTableMeta.getColumnMetas().size(), targetTableMeta.getColumnMetas().size());
            throw new ColumnCountNotMatchException(jobId, errMsg);
        }
    }

    private void initJoinTables(long tableId, JobMeta jobMeta) throws SQLException {
        if (jobMeta.getLogicTableConfig().getTableConfig().getJoinTables().size() > 0) {
            List<JoinTableInfo> joinTableInfoList = jobMeta.getLogicTableConfig().getTableConfig().getJoinTables();
            if (jobMeta.getSourceTableMetaMap() == null) {
                jobMeta.setSourceTableMetaMap(new HashMap<String, TableMeta>(joinTableInfoList.size()));
            }
            for (JoinTableInfo joinTableInfo : joinTableInfoList) {
                TableMeta sourceJoinTableMeta = TableMetaManager.getTableMeta(jobMeta.getSourceAdapter(), joinTableInfo.getTableName(), tableId);
                if (sourceJoinTableMeta == null) {
                    throw new DefinedException(ErrorType.TABLE_META_INIT_FAILED, String.format("init source table meta failed, ds = %s,table = %s", jobMeta.getSourceAdapter().getDataSourceInfo().getDataSourceName(), joinTableInfo.getTableName()));
                }
                jobMeta.getSourceTableMetaMap().put(joinTableInfo.getTableName(), sourceJoinTableMeta);
            }
        }
    }

    public void initSubTables(Long tableId, JobMeta jobMeta) throws SQLException {
        List<SubTableInfo> subTableInfoList;
        if (jobMeta.getLogicTableConfig().getTableConfig().getSubTables().size() > 0) {
            subTableInfoList = jobMeta.getLogicTableConfig().getTableConfig().getSubTables();
            jobMeta.setTargetTableMetaMap(new HashMap<String, TableMeta>(subTableInfoList.size()));
            for (SubTableInfo subTableInfo : subTableInfoList) {
                TableMeta targetSubTableMeta = TableMetaManager.getTableMeta(jobMeta.getTargetAdapter(), subTableInfo.getTargetTableName(), tableId);
                if (targetSubTableMeta == null) {
                    throw new DefinedException(ErrorType.TABLE_META_INIT_FAILED, String.format("init target table meta failed, ds = %s, table = %s", jobMeta.getTargetAdapter().getDataSourceInfo().getDataSourceName(), subTableInfo.getTargetTableName()));
                }
                jobMeta.getTargetTableMetaMap().put(subTableInfo.getTableName(), targetSubTableMeta);
            }
        }
        if (jobMeta.getLogicTableConfig().getTableConfig().getSubTables().size() > 0) {
            subTableInfoList = jobMeta.getLogicTableConfig().getTableConfig().getSubTables();
            jobMeta.setSourceTableMetaMap(new HashMap<String, TableMeta>(subTableInfoList.size()));
            for (SubTableInfo subTableInfo : subTableInfoList) {
                TableMeta sourceSubTableMeta = TableMetaManager.getTableMeta(jobMeta.getSourceAdapter(), subTableInfo.getTableName(), tableId);
                if (sourceSubTableMeta == null) {
                    throw new DefinedException(ErrorType.TABLE_META_INIT_FAILED, String.format("init source table meta failed, ds = %s, table = %s", jobMeta.getSourceAdapter().getDataSourceInfo().getDataSourceName(), subTableInfo.getTableName()));
                }
                jobMeta.getSourceTableMetaMap().put(subTableInfo.getTableName(), sourceSubTableMeta);
            }
        }
    }
}

