/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.data;

import com.oceanbase.tools.migrator.common.configure.DirtyRowAction;
import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.core.data.AbstractData;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Row
extends AbstractData {
    private static final Logger log = LoggerFactory.getLogger(Row.class);
    protected List<Column> columnList = null;
    protected PrimaryKey primaryKey = null;
    protected BatchRows ownerBatchRows = null;
    private boolean isDirtyRow = false;

    public Row(int size) {
        this.columnList = new ArrayList<Column>(size);
    }

    public Row() {
        this(50);
    }

    @Override
    public AbstractData getOwner() {
        return this.ownerBatchRows;
    }

    public void setOwnerBatchRows(BatchRows ownerBatchRows) {
        this.ownerBatchRows = ownerBatchRows;
    }

    public void addColumn(Column column) {
        this.columnList.add(column);
    }

    public List<Column> getColumnList() {
        return this.columnList;
    }

    public long getDataSize() {
        long dataSize = 0L;
        for (Column column : this.columnList) {
            dataSize += column.getByteSize();
        }
        return dataSize;
    }

    public PrimaryKey getPrimaryKey() {
        if (this.primaryKey == null) {
            List<ColumnMeta> sortedPrimaryColumnMetas = this.ownerBatchRows.getTableMeta().getShardKeyColumns();
            this.primaryKey = new PrimaryKey(sortedPrimaryColumnMetas.size());
            for (ColumnMeta sortedPrimaryColumnMeta : sortedPrimaryColumnMetas) {
                this.primaryKey.addKeyColumn(this.columnList.get(sortedPrimaryColumnMeta.getColIdx()));
            }
        }
        return this.primaryKey;
    }

    public boolean equals(Row otherRow) {
        List<Column> thisColumnList = this.columnList;
        List<Column> otherColumnList = otherRow.getColumnList();
        if (thisColumnList.size() != otherColumnList.size()) {
            return false;
        }
        for (int i = 0; i < thisColumnList.size(); ++i) {
            if (thisColumnList.get(i).isMatch(otherColumnList.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isMatch(Row otherRow) {
        List<Column> thisColumnList = this.columnList;
        List<Column> otherColumnList = otherRow.getColumnList();
        if (thisColumnList.size() != otherColumnList.size()) {
            String errMsg = String.format("table name = %s, srcCount = %d, targetCount = %d", this.ownerBatchRows.getTableMeta().getName(), thisColumnList.size(), otherColumnList.size());
            this.setError(ErrorType.CHECK_COLUMN_COUNT_NOT_MATCH, errMsg);
            log.error("check column count not match, " + errMsg);
            return false;
        }
        for (int i = 0; i < thisColumnList.size(); ++i) {
            if (thisColumnList.get(i).isMatch(otherColumnList.get(i)) || this.isDirtyRow) continue;
            this.handleDirtyRow(thisColumnList, otherColumnList, i);
        }
        return true;
    }

    private void handleDirtyRow(List<Column> thisColumnList, List<Column> otherColumnList, int i) {
        JobMeta jobMeta = this.ownerBatchRows.getOwnerTransRows().getOwnerTaskMeta().getJobMeta();
        String unmatchedColumnName = this.ownerBatchRows.getTableMeta().getColumnMetas().get(i).getName();
        boolean isAllowedDirtyColumn = false;
        if (jobMeta.getAllowedDirtyColumns().size() > 0) {
            for (String allowedDirtyColumn : jobMeta.getAllowedDirtyColumns()) {
                if (!unmatchedColumnName.equalsIgnoreCase(allowedDirtyColumn)) continue;
                isAllowedDirtyColumn = true;
                break;
            }
        } else {
            isAllowedDirtyColumn = true;
        }
        boolean throwError = true;
        boolean isDirtyRow = true;
        if (isAllowedDirtyColumn) {
            switch (jobMeta.getDirtyRowAction()) {
                case RAISE_ERROR: {
                    break;
                }
                case SKIP: {
                    if (jobMeta.getJobStat().getUnMatchedRowCount() >= jobMeta.getMaxAllowedDirtyRowCount() && jobMeta.getMaxAllowedDirtyRowCount() != -1L) break;
                    throwError = false;
                    break;
                }
                case CHEAT_AS_NORMAL: {
                    if (jobMeta.getJobStat().getUnMatchedRowCount() >= jobMeta.getMaxAllowedDirtyRowCount() && jobMeta.getMaxAllowedDirtyRowCount() != -1L) break;
                    throwError = false;
                    isDirtyRow = false;
                    break;
                }
            }
        }
        String errMsg = String.format("table name = %s, srcKey = %s, column name = %s, srcValue = %s, targetValue = %s", this.ownerBatchRows.getTableMeta().getName(), this.getPrimaryKey().toSqlString(), this.ownerBatchRows.getTableMeta().getColumnMetas().get(i).getName(), thisColumnList.get(i).toString(), otherColumnList.get(i).toString());
        log.info("[row unmatched] " + errMsg);
        jobMeta.getJobStat().addUnMatchedRowCount(1L);
        if (isDirtyRow) {
            this.setDirtyRow(true);
            if (jobMeta.getDirtyRowAction().equals((Object)DirtyRowAction.REMIGRATE)) {
                this.ownerBatchRows.getOwnerTransRows().setHasDirty(true);
            }
            if (this.ownerBatchRows.getOwnerTransRows().hasSubTable()) {
                this.ownerBatchRows.getOwnerTransRows().setDirty(true);
            }
        }
        if (throwError && !jobMeta.getDirtyRowAction().equals((Object)DirtyRowAction.REMIGRATE)) {
            throw new DefinedException(ErrorType.CHECK_COLUMN_NOT_MATCH, errMsg);
        }
    }

    public boolean isDirtyRow() {
        return this.isDirtyRow;
    }

    public void setDirtyRow(boolean dirtyRow) {
        this.isDirtyRow = dirtyRow;
    }

    public void resetDirtyRow() {
        this.isDirtyRow = false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("columnList", this.columnList).toString();
    }
}

