/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.common.util.VersionUtil;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.handler.AbstractDeleteHandler;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDeleteHandler {
    private static final Logger log = LoggerFactory.getLogger(DataDeleteHandler.class);

    public static void delete(final TransRows transRows) throws SQLException {
        if (transRows.getRowCount() == 0) {
            return;
        }
        final TaskMeta taskMeta = transRows.getOwnerTaskMeta();
        DataSourceAdapter dataSourceAdapter = taskMeta.getJobMeta().getSourceAdapter();
        HandlerUtils.runWithRetry(new AbstractDeleteHandler(dataSourceAdapter){

            @Override
            public Object run(Connection connection) throws SQLException {
                boolean batchDeleteByIn = false;
                try {
                    batchDeleteByIn = this.dataSourceAdapter.getDataBaseType() != DataBaseType.MYSQL || VersionUtil.compareVersions(this.dataSourceAdapter.getDbVersion(), "5.7.0") >= 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int i = transRows.getBatchRowsCount() - 1; i >= 0; --i) {
                    DataDeleteHandler.deleteBatchRows(connection, transRows.getBatchRows(i), taskMeta, batchDeleteByIn);
                    if (transRows.getBatchRows(i).getRowCount() <= 0) continue;
                    log.debug("{}: {} Delete {} Rows.[{} - {}]", new Object[]{this.dataSourceAdapter.getDataSourceInfo().getDataSourceName(), transRows.getBatchRows(i).getTableMeta().getName(), transRows.getBatchRows(i).getRowCount(), transRows.getBatchRows(i).getMinPrimaryKey().toSqlString(), transRows.getBatchRows(i).getMaxPrimaryKey().toSqlString()});
                }
                return null;
            }
        });
    }

    private static String getDeleteSql(TableMeta phyTableMeta) {
        String deleteSql = String.format("DELETE /*+ index(%s %s) */ FROM `%s` WHERE ", phyTableMeta.getName(), phyTableMeta.getShardKeyName(), phyTableMeta.getName());
        deleteSql = deleteSql + SqlUtils.getSingleGetCondition(phyTableMeta.getShardKeyColumns());
        return deleteSql;
    }

    private static String getDeleteSql(TableMeta phyTableMeta, int deleteBatchSize) {
        String deleteSql = String.format("DELETE /*+ index(%s %s) */ FROM `%s` WHERE ", phyTableMeta.getName(), phyTableMeta.getShardKeyName(), phyTableMeta.getName());
        deleteSql = deleteSql + SqlUtils.getMultiGetCondition(phyTableMeta.getShardKeyColumns(), deleteBatchSize);
        return deleteSql;
    }

    private static void deleteBatchRows(Connection connection, BatchRows batchRows, TaskMeta taskMeta, boolean deleteByIn) throws SQLException {
        if (batchRows.getRowCount() > 0) {
            int deleteBatchSize = taskMeta.getJobMeta().getDeleteBatchSize();
            TableMeta phyTableMeta = taskMeta.getJobMeta().getSourceTableMeta(batchRows.getTableMeta().getName());
            List<List<Row>> toDeleteBatchRow = DataDeleteHandler.splitBatchRows(batchRows, deleteBatchSize);
            try {
                for (List<Row> rows : toDeleteBatchRow) {
                    if (rows.isEmpty()) continue;
                    if (deleteByIn) {
                        DataDeleteHandler.deleteBatchRowsByIn(connection, phyTableMeta, rows);
                        continue;
                    }
                    DataDeleteHandler.deleteBatchRowsByEqual(connection, phyTableMeta, rows);
                }
            }
            catch (SQLException e) {
                log.warn("failed to delete batch rows, taskMeta = " + taskMeta, (Throwable)e);
                throw e;
            }
        } else if (taskMeta.getJobMeta().getNeedPrintSqlTrace().booleanValue()) {
            log.info(String.format("table[%s] getRowCount() = 0", batchRows.getTableMeta().getName()));
        }
    }

    private static List<List<Row>> splitBatchRows(BatchRows batchRows, int deleteBatchSize) {
        List toDeleteRows = batchRows.getRows().stream().filter(row -> !row.isDirtyRow()).collect(Collectors.toList());
        LinkedList<List<Row>> splitRows = new LinkedList<List<Row>>();
        int index = 0;
        int count = toDeleteRows.size();
        while (index < count) {
            if (index + deleteBatchSize < count) {
                splitRows.add(toDeleteRows.subList(index, index + deleteBatchSize));
                index += deleteBatchSize;
                continue;
            }
            splitRows.add(toDeleteRows.subList(index, count));
            index = count;
        }
        return splitRows;
    }

    private static void deleteBatchRowsByIn(Connection connection, TableMeta tableMeta, List<Row> rows) throws SQLException {
        String deleteSql = DataDeleteHandler.getDeleteSql(tableMeta, rows.size());
        List<ColumnMeta> multiGetColumnMetas = tableMeta.getShardKeyColumns();
        int pkColumnCount = tableMeta.getShardKeyColumns().size();
        int index = 0;
        try (PreparedStatement ps = connection.prepareStatement(deleteSql);){
            for (Row row : rows) {
                for (int keyIdx = 0; keyIdx < pkColumnCount; ++keyIdx) {
                    SqlUtils.setPsParam(ps, ++index, row.getColumnList().get(multiGetColumnMetas.get(keyIdx).getColIdx()));
                }
            }
            ps.executeUpdate();
            ps.clearParameters();
        }
    }

    private static void deleteBatchRowsByEqual(Connection connection, TableMeta tableMeta, List<Row> rows) throws SQLException {
        String deleteSql = DataDeleteHandler.getDeleteSql(tableMeta);
        List<ColumnMeta> multiGetColumnMetas = tableMeta.getShardKeyColumns();
        int pkColumnCount = tableMeta.getShardKeyColumns().size();
        try (PreparedStatement ps = connection.prepareStatement(deleteSql);){
            for (Row row : rows) {
                for (int keyIdx = 0; keyIdx < pkColumnCount; ++keyIdx) {
                    SqlUtils.setPsParam(ps, keyIdx + 1, row.getColumnList().get(multiGetColumnMetas.get(keyIdx).getColIdx()));
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }
}

