/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.enums.MigrationInsertAction;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWriterHandler {
    private static final Logger log = LoggerFactory.getLogger(DataWriterHandler.class);
    private static final int DUPLICATE_ENTRY_CODE = 1062;
    private static final int VERSION_NOT_SUPPORT = 1235;

    private DataWriterHandler() {
    }

    public static void write(TransRows rows) throws SQLException {
        if (rows.getRowCount() == 0) {
            return;
        }
        DataSourceAdapter targetDs = rows.getOwnerTaskMeta().getJobMeta().getTargetAdapter();
        HandlerUtils.runWithRetry(() -> {
            for (int i = rows.getBatchRowsCount() - 1; i >= 0; --i) {
                DataWriterHandler.writeBatchRows(targetDs, rows.getBatchRows(i));
            }
            return null;
        });
    }

    private static String getWritUpdateModeSql(BatchRows batchRows, TaskMeta taskMeta) throws SQLException {
        TableMeta phyTableMeta = taskMeta.getJobMeta().getTargetTableMeta(batchRows.getTableMeta().getName());
        String writeSql = DataWriterHandler.isFullPKTable(phyTableMeta) != false ? DataWriterHandler.getWriteSqlReplaceMode(batchRows, taskMeta) : DataWriterHandler.getWriteSqlDuplicateUpdateMode(batchRows, taskMeta);
        return writeSql;
    }

    private static Boolean isFullPKTable(TableMeta tableMeta) {
        boolean isFullPkTable = true;
        for (ColumnMeta columnMeta : tableMeta.getColumnMetas()) {
            if (columnMeta.isShardKeyColumn()) continue;
            isFullPkTable = false;
            break;
        }
        return isFullPkTable;
    }

    private static String getWriteSqlReplaceMode(BatchRows batchRows, TaskMeta taskMeta) {
        String writeSqlTmpl = "REPLACE INTO `%s` (%s) VALUES %s";
        TableMeta tableMeta = batchRows.getTableMeta();
        String columnList = SqlUtils.getColumnListString(tableMeta);
        String columnRefList = SqlUtils.getColumnRefList(tableMeta.getColumnMetas().size());
        return String.format(writeSqlTmpl, taskMeta.getJobMeta().getTargetTableMeta().getName(), columnList, columnRefList);
    }

    private static String getWriteSqlDuplicateUpdateMode(BatchRows batchRows, TaskMeta taskMeta) {
        String writeSqlTmpl = "INSERT INTO `%s` (%s) VALUES %s ON DUPLICATE KEY UPDATE %s";
        TableMeta batchRowsTableMeta = batchRows.getTableMeta();
        TableMeta phyTableMeta = taskMeta.getJobMeta().getTargetTableMeta(batchRowsTableMeta.getName());
        String columnList = SqlUtils.getColumnListString(batchRowsTableMeta);
        String columnRefList = SqlUtils.getColumnRefList(batchRowsTableMeta.getColumnMetas().size());
        String updateList = batchRowsTableMeta.getDataBaseType() == DataBaseType.ORACLE || batchRowsTableMeta.getDataBaseType() == DataBaseType.OCEANBASE_ORACLE_MODE ? SqlUtils.getOracleUpdateListString(phyTableMeta) : SqlUtils.getUpdateListString(phyTableMeta);
        return String.format(writeSqlTmpl, phyTableMeta.getName(), columnList, columnRefList, updateList);
    }

    private static String getWriteSqlNormalMode(BatchRows batchRows, TaskMeta taskMeta) {
        String writeSqlTmpl = "INSERT INTO `%s` (%s) VALUES %s";
        TableMeta batchRowsTableMeta = batchRows.getTableMeta();
        TableMeta phyTableMeta = taskMeta.getJobMeta().getTargetTableMeta(batchRowsTableMeta.getName());
        String columnList = SqlUtils.getColumnListString(batchRowsTableMeta);
        String columnRefList = SqlUtils.getColumnRefList(batchRowsTableMeta.getColumnMetas().size());
        return String.format(writeSqlTmpl, phyTableMeta.getName(), columnList, columnRefList);
    }

    private static void writeBatchRows(DataSourceAdapter dataSourceAdapter, BatchRows batchRows) throws SQLException {
        JobMeta jobMeta = batchRows.getOwnerTransRows().getOwnerTaskMeta().getJobMeta();
        TableMeta phyTableMeta = jobMeta.getTargetTableMeta(batchRows.getTableMeta().getName());
        Map<Long, BatchRows> batchRowsMap = HandlerUtils.groupBatchRowByPartition(batchRows, phyTableMeta.getName(), jobMeta.getTargetAdapter());
        MigrationInsertAction insertAction = batchRows.getOwnerTransRows().getOwnerTaskMeta().getJobMeta().getLogicTableConfig().getMigrationInsertAction();
        for (BatchRows groupedBatchRows : batchRowsMap.values()) {
            if (insertAction == MigrationInsertAction.INSERT_DUPLICATE_UPDATE) {
                DataWriterHandler.writeBatchRowsByDuplicateUpdate(dataSourceAdapter, groupedBatchRows, batchRows.getOwnerTransRows().getOwnerTaskMeta());
                continue;
            }
            try {
                DataWriterHandler.writeBatchRows(dataSourceAdapter, groupedBatchRows, batchRows.getOwnerTransRows().getOwnerTaskMeta(), insertAction);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 1062) {
                    DataWriterHandler.writeBatchRowsByDuplicateUpdate(dataSourceAdapter, groupedBatchRows, batchRows.getOwnerTransRows().getOwnerTaskMeta());
                    continue;
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBatchRows(DataSourceAdapter dataSourceAdapter, BatchRows batchRows, TaskMeta taskMeta, MigrationInsertAction insertAction) throws SQLException {
        String writeSql = DataWriterHandler.getWriteSqlNormalMode(batchRows, taskMeta);
        if (taskMeta.getJobMeta().getNeedPrintSqlTrace().booleanValue()) {
            log.info("getBatchWriteSql = " + writeSql);
        }
        if (batchRows.getRowCount() > 0) {
            log.debug("{}: {} Write {} Rows.", new Object[]{dataSourceAdapter.getDataSourceInfo().getDataSourceName(), batchRows.getTableMeta().getName(), batchRows.getRowCount()});
        }
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        int writeBatchSize = taskMeta.getJobMeta().getWriterBatchSize();
        boolean needSingleInsert = false;
        List<Row> rows = batchRows.getRows();
        if (rows.isEmpty()) {
            return;
        }
        try {
            connection = dataSourceAdapter.getConnectionForWrite(writeSql, rows.get(0));
            preparedStatement = connection.prepareStatement(writeSql);
            for (int i = 0; i < rows.size(); ++i) {
                SqlUtils.setPreparedStatement(preparedStatement, rows.get(i));
                preparedStatement.addBatch();
                if ((i + 1) % writeBatchSize != 0 && i != rows.size() - 1) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
        }
        catch (SQLException e) {
            block21: {
                try {
                    if (e.getErrorCode() == 1235) {
                        log.info("failed to batch insert, retry with single insert", (Throwable)e);
                        needSingleInsert = true;
                        if (preparedStatement != null) {
                            preparedStatement.clearBatch();
                        }
                        break block21;
                    }
                    if (e.getErrorCode() == 1062 && insertAction == MigrationInsertAction.INSERT_IGNORE) {
                        needSingleInsert = true;
                        if (preparedStatement != null) {
                            preparedStatement.clearBatch();
                        }
                        break block21;
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(preparedStatement);
                    DbUtils.closeQuietly(connection);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly(preparedStatement);
            DbUtils.closeQuietly(connection);
        }
        DbUtils.closeQuietly(preparedStatement);
        DbUtils.closeQuietly(connection);
        if (needSingleInsert) {
            try {
                connection = dataSourceAdapter.getConnectionForWrite();
                preparedStatement = connection.prepareStatement(writeSql);
                int singleInsertTotal = rows.size();
                int singleInsertDuplicate = 0;
                for (Row row : rows) {
                    SqlUtils.setPreparedStatement(preparedStatement, row);
                    try {
                        preparedStatement.execute();
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == 1062 && insertAction == MigrationInsertAction.INSERT_IGNORE) {
                            if (taskMeta.getJobMeta().getNeedPrintSqlTrace().booleanValue()) {
                                log.info(String.format("Duplicate Key Found Table[%s], PrimKey[%s]", batchRows.getTableMeta().getName(), row.getPrimaryKey()));
                            }
                            taskMeta.getJobMeta().getJobStat().addUnMatchedRowCount(1L);
                            ++singleInsertDuplicate;
                            continue;
                        }
                        throw e;
                    }
                }
                log.info(String.format("Try SingleInsert %d lines, Duplicate Key[%d]", singleInsertTotal, singleInsertDuplicate));
            }
            finally {
                DbUtils.closeQuietly(preparedStatement);
                DbUtils.closeQuietly(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBatchRowsByDuplicateUpdate(DataSourceAdapter dataSourceAdapter, BatchRows batchRows, TaskMeta taskMeta) throws SQLException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        int writeBatchSize = taskMeta.getJobMeta().getWriterBatchSize();
        boolean needSingleInsert = false;
        List<Row> rows = batchRows.getRows();
        String writeSql = DataWriterHandler.getWritUpdateModeSql(batchRows, taskMeta);
        if (taskMeta.getJobMeta().getNeedPrintSqlTrace().booleanValue()) {
            log.info("getBatchWriteSqlByUpdate = " + writeSql);
        }
        try {
            connection = dataSourceAdapter.getConnectionForWrite(writeSql, rows.get(0));
            preparedStatement = connection.prepareStatement(writeSql);
            for (int i = 0; i < rows.size(); ++i) {
                SqlUtils.setPreparedStatement(preparedStatement, rows.get(i));
                preparedStatement.addBatch();
                if ((i + 1) % writeBatchSize != 0 && i != rows.size() - 1) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
        }
        catch (SQLException e) {
            block13: {
                try {
                    if (e.getErrorCode() == 1235) {
                        log.info("failed to batch insert, retry with single insert", (Throwable)e);
                        needSingleInsert = true;
                        if (preparedStatement != null) {
                            preparedStatement.clearBatch();
                        }
                        break block13;
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(preparedStatement);
                    DbUtils.closeQuietly(connection);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly(preparedStatement);
            DbUtils.closeQuietly(connection);
        }
        DbUtils.closeQuietly(preparedStatement);
        DbUtils.closeQuietly(connection);
        if (needSingleInsert) {
            try {
                connection = dataSourceAdapter.getConnectionForWrite();
                preparedStatement = connection.prepareStatement(writeSql);
                for (Row row : rows) {
                    SqlUtils.setPreparedStatement(preparedStatement, row);
                    preparedStatement.execute();
                }
            }
            finally {
                DbUtils.closeQuietly(preparedStatement);
                DbUtils.closeQuietly(connection);
            }
        }
    }
}

