/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.core.builder.SqlBuilderFactory;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.core.data.RowUtils;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.handler.AbstractReadHandler;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiGetHandler {
    private static final Logger log = LoggerFactory.getLogger(MultiGetHandler.class);

    public static TransRows multiGetTargetTransRows(final TransRows sourceTransRows) throws SQLException {
        TransRows transRows = null;
        final TaskMeta taskMeta = sourceTransRows.getOwnerTaskMeta();
        final DataSourceAdapter targetAdapter = sourceTransRows.getOwnerTaskMeta().getJobMeta().getTargetAdapter();
        transRows = (TransRows)HandlerUtils.runWithRetry(new AbstractReadHandler(targetAdapter){

            @Override
            public Object run(Connection connection) throws SQLException {
                TransRows retTransRows = new TransRows();
                retTransRows.setOwnerTaskMeta(taskMeta);
                int batchSize = taskMeta.getJobMeta().getCheckMultigetBatchSize();
                for (int i = 0; i < sourceTransRows.getBatchRowsCount(); ++i) {
                    BatchRows sourceBatchRows = sourceTransRows.getBatchRows(i);
                    BatchRows targetBatchRows = MultiGetHandler.multiGetTargetBatchRows(connection, sourceBatchRows, batchSize);
                    if (sourceBatchRows.getRowCount() > 0) {
                        log.debug("{}: {} MultiGet {} Rows.[{} - {}]", new Object[]{targetAdapter.getDataSourceInfo().getDataSourceName(), sourceBatchRows.getTableMeta().getName(), targetBatchRows.getRowCount(), sourceBatchRows.getMinPrimaryKey().toSqlString(), sourceBatchRows.getMaxPrimaryKey().toSqlString()});
                    }
                    retTransRows.addBatchRows(targetBatchRows);
                }
                return retTransRows;
            }
        });
        return transRows;
    }

    private static BatchRows multiGetTargetBatchRows(Connection connection, BatchRows srcBatchRows, int batchSize) throws SQLException {
        BatchRows batchRows = new BatchRows();
        TableMeta srcRowTableMeta = srcBatchRows.getTableMeta();
        JobMeta jobMeta = srcBatchRows.getOwnerTransRows().getOwnerTaskMeta().getJobMeta();
        TableMeta phyTableMeta = jobMeta.getTargetTableMeta(srcRowTableMeta.getName());
        List<ColumnMeta> multiGetKeyColumnMetas = MultiGetHandler.getMultiGetKeyColumnMetas(srcRowTableMeta, phyTableMeta);
        if (srcBatchRows.getRowCount() > 0) {
            List<List<Row>> lists = MultiGetHandler.splitBatchRows(srcBatchRows, batchSize);
            try {
                for (List<Row> rows : lists) {
                    if (rows.isEmpty()) continue;
                    String preparedSql = MultiGetHandler.getPreparedMultiGetTargetSql(srcRowTableMeta, phyTableMeta, multiGetKeyColumnMetas, rows.size());
                    int index = 0;
                    PreparedStatement ps = connection.prepareStatement(preparedSql);
                    Throwable throwable = null;
                    try {
                        for (Row row : rows) {
                            for (ColumnMeta multiGetKeyColumnMeta : multiGetKeyColumnMetas) {
                                SqlUtils.setPsParam(ps, ++index, row.getColumnList().get(multiGetKeyColumnMeta.getColIdx()));
                            }
                        }
                        DataBaseType dbType = MultiGetHandler.getBatchRowsDbType(srcBatchRows);
                        if (jobMeta.getNeedPrintSqlTrace().booleanValue()) {
                            log.info(String.format("multiGetTargetBatchRowsSql = %s", ps.toString()));
                        }
                        MultiGetHandler.addResultSetToBatchRows(ps.executeQuery(), batchRows, dbType);
                        ps.clearParameters();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ps == null) continue;
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ps.close();
                    }
                }
            }
            catch (SQLException e) {
                log.warn("failed to get batch rows with multiget", (Throwable)e);
                throw e;
            }
        }
        return batchRows;
    }

    private static String getPreparedMultiGetTargetSql(TableMeta srcRowTableMeta, TableMeta phyTableMeta, List<ColumnMeta> multiGetKeyColumnMetas, int batchSize) {
        AbstractSqlBuilder builder = SqlBuilderFactory.getSqlBuilder(phyTableMeta.getDataBaseType());
        builder.setSelectColumns(srcRowTableMeta.getColumnListStr());
        builder.setTableName(phyTableMeta.getName());
        builder.addPrimaryKeyCondition(SqlUtils.getMultiGetCondition(multiGetKeyColumnMetas, batchSize));
        builder.setOrderByColumns(srcRowTableMeta.getShardKeyColumns());
        builder.setOrderByMethod(OrderByMethod.ASC);
        builder.setShardKeyName(srcRowTableMeta.getShardKeyName());
        return builder.getReadDataSql();
    }

    private static List<ColumnMeta> getMultiGetKeyColumnMetas(TableMeta srcTableMeta, TableMeta targetTableMeta) {
        ArrayList<ColumnMeta> multiGetKeyColumnMetas = new ArrayList<ColumnMeta>(targetTableMeta.getShardKeyColumns().size());
        for (int i = 0; i < targetTableMeta.getShardKeyColumns().size(); ++i) {
            String columnName = targetTableMeta.getShardKeyColumns().get(i).getName();
            ColumnMeta columnMeta = srcTableMeta.getColumnMeta(columnName);
            if (columnMeta == null && (columnMeta = srcTableMeta.getColumnMeta(columnName.toUpperCase())) == null) {
                throw new UnExpectedException("column meta should not be null here, columnName = " + columnName);
            }
            multiGetKeyColumnMetas.add(columnMeta);
        }
        return multiGetKeyColumnMetas;
    }

    public static BatchRows getBatchRowsWithMultiget(Connection connection, String preparedSql, BatchRows srcBatchRows, List<ColumnMeta> multiGetKeyColumnMetas, int batchSize) throws SQLException {
        return MultiGetHandler.getBatchRowsWithMultiget(connection, preparedSql, srcBatchRows, multiGetKeyColumnMetas, batchSize, null);
    }

    public static BatchRows getBatchRowsWithMultiget(Connection connection, String preparedSql, BatchRows srcBatchRows, List<ColumnMeta> multiGetKeyColumnMetas, int batchSize, String additionKeyValue) throws SQLException {
        boolean hasAdditionKey;
        BatchRows batchRows = new BatchRows();
        boolean bl = hasAdditionKey = additionKeyValue != null && additionKeyValue.length() > 0;
        if (hasAdditionKey && batchSize % 2 != 0) {
            throw new DefinedException(ErrorType.SUB_TABLE_INVALID_BATCH_SIZE, "batch size should mod 2 if has sub table");
        }
        if (srcBatchRows.getRowCount() > 0) {
            PreparedStatement preparedStatement = null;
            long loopCnt = srcBatchRows.getRowCount();
            if (loopCnt % (long)batchSize != 0L) {
                loopCnt += (long)batchSize - loopCnt % (long)batchSize;
            }
            int pkColumnCnt = multiGetKeyColumnMetas.size();
            int paramIndex = 0;
            try {
                preparedStatement = connection.prepareStatement(preparedSql);
                int addedRowCount = 0;
                int i = 0;
                while ((long)i < loopCnt) {
                    if (i >= srcBatchRows.getRowCount()) {
                        for (int keyIdx = 0; keyIdx < pkColumnCnt; ++keyIdx) {
                            preparedStatement.setNull(++paramIndex, 12);
                        }
                        ++addedRowCount;
                    } else {
                        int keyIdx;
                        Row row = srcBatchRows.getRow(i);
                        for (keyIdx = 0; keyIdx < pkColumnCnt; ++keyIdx) {
                            SqlUtils.setPsParam(preparedStatement, ++paramIndex, row.getColumnList().get(multiGetKeyColumnMetas.get(keyIdx).getColIdx()));
                        }
                        ++addedRowCount;
                        if (hasAdditionKey) {
                            for (keyIdx = 0; keyIdx < pkColumnCnt; ++keyIdx) {
                                if (keyIdx == pkColumnCnt - 1) {
                                    preparedStatement.setString(++paramIndex, row.getColumnList().get(multiGetKeyColumnMetas.get(keyIdx).getColIdx()).getString() + additionKeyValue);
                                    continue;
                                }
                                SqlUtils.setPsParam(preparedStatement, ++paramIndex, row.getColumnList().get(multiGetKeyColumnMetas.get(keyIdx).getColIdx()));
                            }
                            ++addedRowCount;
                        }
                    }
                    if (addedRowCount % batchSize == 0) {
                        DataBaseType dbType = MultiGetHandler.getBatchRowsDbType(srcBatchRows);
                        MultiGetHandler.addResultSetToBatchRows(preparedStatement.executeQuery(), batchRows, dbType);
                        paramIndex = 0;
                        addedRowCount = 0;
                        preparedStatement.clearParameters();
                    }
                    ++i;
                }
            }
            catch (SQLException e) {
                log.warn("failed to get batch rows with multiget", (Throwable)e);
                throw e;
            }
            finally {
                DbUtils.closeQuietly(preparedStatement);
            }
        }
        return batchRows;
    }

    private static List<List<Row>> splitBatchRows(BatchRows batchRows, int batchSize) {
        List<Row> rows = batchRows.getRows();
        LinkedList<List<Row>> splitRows = new LinkedList<List<Row>>();
        int index = 0;
        int count = rows.size();
        while (index < count) {
            if (index + batchSize < count) {
                splitRows.add(rows.subList(index, index + batchSize));
                index += batchSize;
                continue;
            }
            splitRows.add(rows.subList(index, count));
            index = count;
        }
        return splitRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addResultSetToBatchRows(ResultSet resultSet, BatchRows batchRows, DataBaseType dbType) throws SQLException {
        try {
            while (resultSet.next()) {
                Row row = RowUtils.getRow(resultSet, dbType);
                if (row == null) continue;
                batchRows.addRow(row);
            }
        }
        finally {
            resultSet.close();
        }
    }

    private static DataBaseType getBatchRowsDbType(BatchRows batchRows) {
        DataBaseType dbType = batchRows.getOwnerTransRows().getOwnerTaskMeta().getJobMeta().getSourceAdapter().getDataBaseType();
        return dbType;
    }
}

