/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.genarator;

import com.oceanbase.tools.migrator.common.dto.TaskGenerator;
import com.oceanbase.tools.migrator.common.element.CursorRange;
import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.common.element.StringColumn;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.exception.JobSqlException;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.core.builder.MysqlSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.ObMysqlSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OracleSqlBuilder;
import com.oceanbase.tools.migrator.core.handler.AbstractReadHandler;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.handler.PartitionReadIterator;
import com.oceanbase.tools.migrator.core.handler.genarator.GeneratorStatus;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIteratorFactory;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTaskGenerator {
    private static final Logger log = LoggerFactory.getLogger(AutoTaskGenerator.class);
    private KeyReadIterator keyReadIterator = null;
    private String dateCondExpr = null;
    private int dateColumnPosInPK = -1;
    private PartitionReadIterator partitionReadIterator = null;
    private List<TaskMeta> taskBuffer = new LinkedList<TaskMeta>();
    private JobMeta jobMeta = null;

    public AutoTaskGenerator(JobMeta jobMeta) throws Exception {
        this.jobMeta = jobMeta;
    }

    public void init() throws Exception {
        PrimaryKey minKey;
        if (this.jobMeta.getGenerator().getGeneratorStatus() != GeneratorStatus.GENERATOR_NEW) {
            this.taskBuffer = this.jobMeta.loadTask();
            log.info("Load {} Tasks", (Object)this.taskBuffer.size());
        }
        List<String> partitionArray = this.jobMeta.getSourceAdapter().getPartitionNames(this.jobMeta.getSourceTableMeta().getName());
        this.partitionReadIterator = new PartitionReadIterator(partitionArray);
        this.keyReadIterator = KeyReadIteratorFactory.getKeyReadIterator(this.jobMeta);
        if (this.jobMeta.isDateColumnPkColumnPrefix()) {
            minKey = new PrimaryKey();
            PrimaryKey maxKey = new PrimaryKey();
            minKey.addKeyColumn(new StringColumn(DataType.DATE, SqlUtils.formatDateString(this.jobMeta.getDateStart(), this.jobMeta.getLogicTableConfig().getMigrateDateFormat())));
            maxKey.addKeyColumn(new StringColumn(DataType.DATE, SqlUtils.formatDateString(this.jobMeta.getDateEnd(), this.jobMeta.getLogicTableConfig().getMigrateDateFormat())));
            this.keyReadIterator.setMinKey(minKey);
            this.keyReadIterator.setMaxKey(maxKey);
        } else if (this.jobMeta.getPrimaryTableMeta().isPkColumn(this.jobMeta.getLogicTableConfig().getMigrateDateColumn())) {
            this.dateCondExpr = this.jobMeta.getDateConditionExpr();
            if (null == this.dateCondExpr) {
                throw new UnExpectedException("dateCondExpr is null || dateColumnPosInPK is negative");
            }
        } else {
            String minPrimaryKey = this.jobMeta.getJobParameter().getMinPrimaryKey();
            if (StringUtils.isNotEmpty((String)minPrimaryKey)) {
                minKey = PrimaryKey.valuesOf(minPrimaryKey);
                this.keyReadIterator.setMinKey(minKey);
            }
        }
        this.keyReadIterator.setDataSourceAdapter(this.jobMeta.getSourceAdapter());
        this.keyReadIterator.setTableName(this.jobMeta.getSourceTableMeta().getName());
        this.keyReadIterator.setTableMeta(this.jobMeta.getPrimaryTableMeta());
        this.keyReadIterator.setBatchSize(this.jobMeta.getLogicTableConfig().getGeneratorBatchSize());
        this.keyReadIterator.setLastUpperBound(this.jobMeta.getGenerator().getGeneratorSavePoint());
        this.keyReadIterator.setPrintSqlTrace(this.jobMeta.getNeedPrintSqlTrace());
        if (this.jobMeta.getGenerator().getGeneratorStatus() == GeneratorStatus.GENERATOR_FINISHED) {
            this.keyReadIterator.setEnd(true);
            this.partitionReadIterator.setEnd();
        } else {
            if (this.jobMeta.getGenerator().getGeneratorPartitionSavepoint().length() > 0) {
                while (!this.partitionReadIterator.getCurrentPartiton().equalsIgnoreCase(this.jobMeta.getGenerator().getGeneratorPartitionSavepoint()) && !this.partitionReadIterator.isEnd().booleanValue()) {
                    this.partitionReadIterator.next();
                }
                if (this.partitionReadIterator.isEnd().booleanValue()) {
                    throw new DefinedException(ErrorType.UNEXPECTED_ERROR, String.format("Can not find saved partition in Partition List,saved partition = [%s]", this.jobMeta.getGenerator().getGeneratorPartitionSavepoint()));
                }
            }
            this.keyReadIterator.setPartitionName(this.partitionReadIterator.getCurrentPartiton());
            this.jobMeta.getGenerator().setGeneratorStatus(GeneratorStatus.GENERATOR_RUNNING);
        }
        log.info(String.format("AutoTaskGenerator, dateCondExpr  = [%s], dataColumnPosInPK = [%s]", this.dateCondExpr, this.dateColumnPosInPK));
        this.jobMeta.storeTaskGenerator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskMeta getNext() {
        List<TaskMeta> list = this.taskBuffer;
        synchronized (list) {
            if (this.taskBuffer.isEmpty()) {
                long startTime = System.currentTimeMillis();
                log.info("Start to generate next task.");
                TaskMeta nextTask = this.generateNextTask();
                log.info("Generate next task success,cost {} ms", (Object)(System.currentTimeMillis() - startTime));
                return nextTask;
            }
            return this.taskBuffer.remove(0);
        }
    }

    private boolean isPkPrefixEqual(CursorRange cursorRange) {
        boolean ret = true;
        PrimaryKey lowerBound = cursorRange.getLowerBound();
        PrimaryKey upperBound = cursorRange.getUpperBound();
        for (int i = 0; i < this.dateColumnPosInPK; ++i) {
            if (lowerBound.getPrimaryKeyColumn(i).equals(upperBound.getPrimaryKeyColumn(i))) continue;
            ret = false;
        }
        return ret;
    }

    private String getCheckSkipRangeSql(CursorRange cursorRange, DataBaseType dbType) {
        String checkSkipRangeSql = "";
        switch (dbType) {
            case OCEANBASEV10: {
                checkSkipRangeSql = this.getObCheckSkipRangeSql(cursorRange);
                break;
            }
            case MYSQL: {
                checkSkipRangeSql = this.getMySQLCheckSkipRangeSql(cursorRange);
                break;
            }
            case ORACLE: 
            case OCEANBASE_ORACLE_MODE: {
                checkSkipRangeSql = this.getOracleCheckSkipRangeSql(cursorRange, dbType);
                break;
            }
            default: {
                log.error(String.format("generate check skip range sql failed, unsupported database type, type=%s", new Object[]{dbType}));
            }
        }
        log.info(String.format("CheckSkipRangeSql = %s", checkSkipRangeSql));
        return checkSkipRangeSql;
    }

    private String getOracleCheckSkipRangeSql(CursorRange cursorRange, DataBaseType dataBaseType) {
        OracleSqlBuilder oracleSqlBuilder = new OracleSqlBuilder();
        TableMeta primaryTableMeta = this.jobMeta.getPrimaryTableMeta();
        PrimaryKey lowerBound = cursorRange.getLowerBound();
        PrimaryKey upperBound = cursorRange.getUpperBound();
        oracleSqlBuilder.setSelectColumns(primaryTableMeta.getPkColumnListStr());
        oracleSqlBuilder.setTableOwner(this.jobMeta.getSourceTableOwner());
        oracleSqlBuilder.setTableName(this.jobMeta.getSourceTableMeta().getName());
        oracleSqlBuilder.setPartitionName(this.partitionReadIterator.getCurrentPartiton());
        for (int i = 0; i < this.dateColumnPosInPK; ++i) {
            oracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getOracleEqualColumnCondition(primaryTableMeta, lowerBound, i));
        }
        if (dataBaseType.equals((Object)DataBaseType.ORACLE)) {
            oracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMinColumnCondition(primaryTableMeta, lowerBound, this.dateColumnPosInPK));
            oracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMaxColumnCondition(primaryTableMeta, upperBound, this.dateColumnPosInPK));
        } else if (dataBaseType.equals((Object)DataBaseType.OCEANBASE_ORACLE_MODE)) {
            oracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMinColumnCondition(primaryTableMeta, lowerBound, this.dateColumnPosInPK));
            oracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMaxColumnCondition(primaryTableMeta, upperBound, this.dateColumnPosInPK));
        }
        oracleSqlBuilder.addPrimaryKeyCondition(this.dateCondExpr);
        oracleSqlBuilder.setOffset(1);
        return oracleSqlBuilder.getSplitSql();
    }

    private String getObCheckSkipRangeSql(CursorRange cursorRange) {
        ObMysqlSqlBuilder selectSqlBuilder = new ObMysqlSqlBuilder();
        TableMeta primaryTableMeta = this.jobMeta.getPrimaryTableMeta();
        PrimaryKey lowerBound = cursorRange.getLowerBound();
        PrimaryKey upperBound = cursorRange.getUpperBound();
        selectSqlBuilder.setSelectColumns(primaryTableMeta.getPkColumnListStr());
        selectSqlBuilder.setTableName(this.jobMeta.getSourceTableMeta().getName());
        selectSqlBuilder.setPartitionName(this.partitionReadIterator.getCurrentPartiton());
        for (int i = 0; i < this.dateColumnPosInPK; ++i) {
            selectSqlBuilder.addPrimaryKeyCondition(SqlUtils.getEqualColumnCondition(primaryTableMeta, lowerBound, i));
        }
        selectSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMinColumnCondition(primaryTableMeta, lowerBound, this.dateColumnPosInPK));
        selectSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMaxColumnCondition(primaryTableMeta, upperBound, this.dateColumnPosInPK));
        selectSqlBuilder.addPrimaryKeyCondition(this.dateCondExpr);
        selectSqlBuilder.setLimit(1);
        return selectSqlBuilder.getSplitSql();
    }

    private String getMySQLCheckSkipRangeSql(CursorRange cursorRange) {
        MysqlSqlBuilder selectSqlBuilder = new MysqlSqlBuilder();
        TableMeta primaryTableMeta = this.jobMeta.getPrimaryTableMeta();
        PrimaryKey lowerBound = cursorRange.getLowerBound();
        PrimaryKey upperBound = cursorRange.getUpperBound();
        selectSqlBuilder.setSelectColumns(primaryTableMeta.getPkColumnListStr());
        selectSqlBuilder.setTableName(this.jobMeta.getSourceTableMeta().getName());
        selectSqlBuilder.setPartitionName(this.partitionReadIterator.getCurrentPartiton());
        for (int i = 0; i < this.dateColumnPosInPK; ++i) {
            selectSqlBuilder.addPrimaryKeyCondition(SqlUtils.getEqualColumnCondition(primaryTableMeta, lowerBound, i));
        }
        selectSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMinColumnCondition(primaryTableMeta, lowerBound, this.dateColumnPosInPK));
        selectSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMaxColumnCondition(primaryTableMeta, upperBound, this.dateColumnPosInPK));
        selectSqlBuilder.addPrimaryKeyCondition(this.dateCondExpr);
        selectSqlBuilder.setLimit(1);
        selectSqlBuilder.setShardKeyName(primaryTableMeta.getShardKeyName());
        return selectSqlBuilder.getSplitSql();
    }

    private boolean canSkipRange(final CursorRange cursorRange) throws SQLException {
        boolean canSkip = false;
        if (this.dateCondExpr != null && this.isPkPrefixEqual(cursorRange)) {
            canSkip = (Boolean)HandlerUtils.runWithRetry(new AbstractReadHandler(this.jobMeta.getSourceAdapter()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run(Connection connection) throws SQLException {
                    boolean ret = false;
                    String sql = AutoTaskGenerator.this.getCheckSkipRangeSql(cursorRange, AutoTaskGenerator.this.jobMeta.getSourceAdapter().getDataBaseType());
                    Statement statement = null;
                    ResultSet resultSet = null;
                    try {
                        statement = connection.createStatement();
                        resultSet = statement.executeQuery(sql);
                        if (!resultSet.next()) {
                            ret = true;
                        }
                    }
                    catch (Throwable throwable) {
                        DbUtils.closeQuietly(resultSet);
                        DbUtils.closeQuietly(statement);
                        throw throwable;
                    }
                    DbUtils.closeQuietly(resultSet);
                    DbUtils.closeQuietly(statement);
                    return ret;
                }
            });
        }
        return canSkip;
    }

    private CursorRange getNextRange() throws SQLException {
        CursorRange retRange = new CursorRange();
        int rowCount = 0;
        int subTaskBatchSize = this.jobMeta.getLogicTableConfig().getSubTaskBatchSize();
        CursorRange nextRange = null;
        block0: while (!(this.partitionReadIterator.isEnd().booleanValue() && this.keyReadIterator.isEnd() || !retRange.cursorRangeIsEmpty())) {
            if (this.keyReadIterator.isEnd()) {
                this.partitionReadIterator.next();
                if (!this.partitionReadIterator.isEnd().booleanValue()) {
                    this.keyReadIterator.reuse();
                    this.keyReadIterator.setPartitionName(this.partitionReadIterator.getCurrentPartiton());
                }
            }
            while (!this.keyReadIterator.isEnd()) {
                nextRange = this.keyReadIterator.getNext();
                if (nextRange != null) {
                    if (retRange.getLowerBound() == null) {
                        retRange.setLowerBound(nextRange.getLowerBound());
                    }
                    retRange.setUpperBound(nextRange.getUpperBound());
                    rowCount += this.keyReadIterator.getBatchSize();
                }
                if (rowCount < subTaskBatchSize) continue;
                if (!this.canSkipRange(retRange)) continue block0;
                log.info("skip range, lowerBound = {}, upperBound = {}", (Object)retRange.getLowerBound(), (Object)retRange.getUpperBound());
                rowCount = 0;
                retRange.setLowerBound(null);
                retRange.setUpperBound(null);
            }
        }
        if (retRange.getLowerBound() == null || retRange.getUpperBound() == null) {
            retRange = null;
        }
        return retRange;
    }

    private TaskMeta generateNextTask() {
        TaskMeta taskMeta = null;
        TaskGenerator taskGenerator = this.jobMeta.getGenerator();
        try {
            CursorRange cursorRange = null;
            if (!this.partitionReadIterator.isEnd().booleanValue() || !this.keyReadIterator.isEnd()) {
                cursorRange = this.getNextRange();
                if (cursorRange != null) {
                    taskMeta = new TaskMeta();
                    taskMeta.setGeneratorId(taskGenerator.getId());
                    taskMeta.setJobMeta(this.jobMeta);
                    taskMeta.setTaskIndex(this.jobMeta.getGenerator().getTaskCount().intValue());
                    taskMeta.setMinPrimaryKey(cursorRange.getLowerBound());
                    taskMeta.setMaxPrimaryKey(cursorRange.getUpperBound());
                    taskMeta.setPartitionName(this.keyReadIterator.getPartitionName());
                    this.jobMeta.storeTaskMeta(taskMeta);
                    taskGenerator.addTaskCount();
                    taskGenerator.setGeneratorSavePoint(this.keyReadIterator.getCursorKey());
                    taskGenerator.setGeneratorPartitionSavepoint(this.keyReadIterator.getPartitionName());
                } else {
                    taskGenerator.setGeneratorStatus(GeneratorStatus.GENERATOR_FINISHED);
                }
            } else {
                log.info("{} Generate Task Finish", (Object)taskGenerator.getId());
                taskGenerator.setGeneratorStatus(GeneratorStatus.GENERATOR_FINISHED);
            }
        }
        catch (SQLException e) {
            log.warn("failed to generate task", (Throwable)e);
            this.jobMeta.setError(new JobSqlException(this.jobMeta.getJobId(), e));
        }
        try {
            this.jobMeta.storeTaskGenerator();
        }
        catch (SQLException e) {
            log.warn("failed to save generator", (Throwable)e);
        }
        return taskMeta;
    }
}

