/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.keyReadIterator;

import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.enums.ShardingStrategy;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.MysqlKeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.ObMysqlKeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.ObOracleKeyReadIterator;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.OracleKeyReadIterator;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyReadIteratorFactory {
    private static final Logger log = LoggerFactory.getLogger(KeyReadIteratorFactory.class);

    public static KeyReadIterator getKeyReadIterator(JobMeta jobMeta) {
        DataBaseType dataBaseType = jobMeta.getSourceAdapter().getDataBaseType();
        KeyReadIterator keyReadIterator = null;
        switch (dataBaseType) {
            case OCEANBASEV10: {
                keyReadIterator = new ObMysqlKeyReadIterator();
                break;
            }
            case MYSQL: {
                keyReadIterator = new MysqlKeyReadIterator();
                break;
            }
            case ORACLE: {
                keyReadIterator = new OracleKeyReadIterator();
                break;
            }
            case OCEANBASE_ORACLE_MODE: {
                keyReadIterator = new ObOracleKeyReadIterator();
                break;
            }
            default: {
                log.warn(String.format("invalid database type:[%s]", dataBaseType.toString()));
            }
        }
        if (keyReadIterator != null && jobMeta.getShardingStrategy() == ShardingStrategy.MATCH) {
            keyReadIterator.setUserDefinedCondition(jobMeta.getLogicTableConfig().getMigrateRule());
        }
        return keyReadIterator;
    }
}

