/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.meta;

import com.oceanbase.tools.migrator.common.configure.DirtyRowAction;
import com.oceanbase.tools.migrator.common.configure.JoinTableInfo;
import com.oceanbase.tools.migrator.common.configure.LogicTableConfig;
import com.oceanbase.tools.migrator.common.configure.SubTableInfo;
import com.oceanbase.tools.migrator.common.dto.JobParameter;
import com.oceanbase.tools.migrator.common.dto.TableSizeInfo;
import com.oceanbase.tools.migrator.common.dto.TaskGenerator;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.enums.JobStatus;
import com.oceanbase.tools.migrator.common.enums.JobType;
import com.oceanbase.tools.migrator.common.enums.ShardingStrategy;
import com.oceanbase.tools.migrator.common.exception.JobCheckNotMatchException;
import com.oceanbase.tools.migrator.common.exception.JobException;
import com.oceanbase.tools.migrator.common.exception.JobSqlException;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.IJobStore;
import com.oceanbase.tools.migrator.core.data.AbstractData;
import com.oceanbase.tools.migrator.core.meta.ClusterMeta;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import com.oceanbase.tools.migrator.core.meta.TenantMeta;
import com.oceanbase.tools.migrator.core.stat.JobStat;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.task.CheckMode;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMeta
extends AbstractData {
    private static final Logger log = LoggerFactory.getLogger(JobMeta.class);
    private String jobId = "-1";
    private JobType jobType;
    private JobStatus jobStatus;
    private LogicTableConfig logicTableConfig = null;
    private JobStat jobStat = new JobStat();
    private String dateStart = null;
    private String dateEnd = null;
    private JobParameter jobParameter;
    private boolean toStop = false;
    private JobException jobError = null;
    private TaskGenerator generator;
    private DataSourceAdapter sourceAdapter = null;
    private DataSourceAdapter targetAdapter = null;
    private TableMeta sourceTableMeta = null;
    private TableMeta targetTableMeta = null;
    private TableMeta primaryTableMeta = null;
    private ClusterMeta sourceCluster = null;
    private ClusterMeta targetCluster = null;
    private TenantMeta sourceTenant = null;
    private TenantMeta targetTenant = null;
    private Map<String, TableMeta> targetTableMetaMap = null;
    private Map<String, TableMeta> sourceTableMetaMap = null;
    private String dateConditionExpr = null;
    private Boolean needPrintSqlTrace = false;
    private ShardingStrategy shardingStrategy = ShardingStrategy.FIXED_LENGTH;
    private IJobStore jobService;
    private ExecutorService executorService;

    public void updateLimitAndStatus() throws JobSqlException {
        try {
            this.jobService.updateLimiter(this);
        }
        catch (SQLException e) {
            throw new JobSqlException(this.jobId, e);
        }
    }

    public void reportStatistic() throws JobSqlException {
        this.jobService.storeJobStatistic(this);
        log.info(String.format("report statistic, jobMeta = %s", this.toString()));
        try {
            this.generator.setProcessedDataSize(this.jobStat.getDataSize());
            this.generator.setProcessedRowCount(this.jobStat.getRowCount());
            this.storeTaskGenerator();
        }
        catch (SQLException e) {
            log.warn("report generator statistic failed.", (Throwable)e);
        }
    }

    public void monitorTaskThreadPool() {
        ThreadPoolExecutor target = (ThreadPoolExecutor)this.executorService;
        if (target != null) {
            log.info("JobId={},Active:[{}],CorePoolSize:[{}]", new Object[]{this.jobId, target.getActiveCount(), target.getCorePoolSize()});
        }
    }

    public TableSizeInfo getSourceTableSizeInfo() {
        try {
            return this.sourceAdapter.getSourceTableSizeInfo(this.sourceTableMeta.getName());
        }
        catch (SQLException e) {
            log.warn(String.format("Get Table RowCount Failed, jobId:%s", this.jobId), (Throwable)e);
            return new TableSizeInfo();
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    @Override
    public void setError(ErrorType type, String errorMessage) {
        switch (type) {
            case CHECK_RECORD_COUNT_NOT_MATCH: 
            case CHECK_ROW_NOT_EXISTS_IN_TARGET: 
            case CHECK_TABLE_COUNT_NOT_MATCH: 
            case CHECK_COLUMN_COUNT_NOT_MATCH: 
            case CHECK_COLUMN_NOT_MATCH: {
                this.jobError = new JobCheckNotMatchException(this.jobId, errorMessage);
                break;
            }
            default: {
                this.jobError = new JobException(this.jobId, errorMessage);
            }
        }
    }

    @Override
    public void setError(JobException exception) {
        this.jobError = exception;
    }

    @Override
    public AbstractData getOwner() {
        return null;
    }

    public int getDeleteBatchSize() {
        return this.logicTableConfig.getDeleteBatchSize();
    }

    public CheckMode getCheckMode() {
        return this.logicTableConfig.getCheckMode();
    }

    public int getCheckMultigetBatchSize() {
        return this.logicTableConfig.getMultigetBatchSize();
    }

    public boolean isEnableImpreciseSavePoint() {
        return this.logicTableConfig.isEnableImpreciseSavePoint();
    }

    public int getSubTaskBatchSize() {
        return this.logicTableConfig.getSubTaskBatchSize();
    }

    public List<SubTableInfo> getSubTables() {
        return this.logicTableConfig.getTableConfig().getSubTables();
    }

    public List<JoinTableInfo> getJoinTables() {
        return this.logicTableConfig.getTableConfig().getJoinTables();
    }

    public int getReaderTaskCount() {
        return this.logicTableConfig.getReaderTaskCount();
    }

    public int getWriterTaskCount() {
        return this.logicTableConfig.getWriterTaskCount();
    }

    public String getMigrateRule() {
        return this.logicTableConfig.getMigrateRule();
    }

    public int getReaderBatchSize() {
        if (this.logicTableConfig.getTableConfig().getSubTables().size() > 0 || this.logicTableConfig.getTableConfig().getJoinTables().size() > 0) {
            return this.logicTableConfig.getMultigetBatchSize();
        }
        return this.logicTableConfig.getReaderBatchSize();
    }

    public int getWriterBatchSize() {
        return this.logicTableConfig.getWriterBatchSize();
    }

    public DirtyRowAction getDirtyRowAction() {
        return this.logicTableConfig.getDirtyRowAction();
    }

    public Long getMaxAllowedDirtyRowCount() {
        return this.logicTableConfig.getMaxAllowedDirtyRowCount();
    }

    public List<String> getAllowedDirtyColumns() {
        return this.logicTableConfig.getAllowedDirtyColumns();
    }

    public String getSourceTableOwner() {
        return this.sourceAdapter.getSchema();
    }

    public String getTargetTableOwner() {
        return this.targetAdapter.getSchema();
    }

    public boolean isDateColumnPkColumnPrefix() {
        return this.primaryTableMeta.getShardKeyColumns().get(0).getName().equals(this.logicTableConfig.getMigrateDateColumn());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("jobId", (Object)this.getJobId()).append("jobStatus", (Object)this.getJobType()).append("jobStat", (Object)this.jobStat).append("shardingStrategy", (Object)this.shardingStrategy).toString();
    }

    public TableMeta getSourceTableMeta(String srcTableName) {
        TableMeta resultTableMeta = this.sourceTableMeta.getName().equals(srcTableName) ? this.sourceTableMeta : (this.sourceTableMetaMap != null && this.sourceTableMetaMap.containsKey(srcTableName) ? this.sourceTableMetaMap.get(srcTableName) : this.sourceTableMeta);
        return resultTableMeta;
    }

    public TableMeta getTargetTableMeta(String srcTableName) {
        TableMeta resultTableMeta = this.sourceTableMeta.getName().equals(srcTableName) ? this.targetTableMeta : (this.targetTableMetaMap != null && this.targetTableMetaMap.containsKey(srcTableName) ? this.targetTableMetaMap.get(srcTableName) : this.targetTableMeta);
        return resultTableMeta;
    }

    public Long queryAbnormalTaskIndex() throws JobSqlException {
        return this.jobService.getAbnormalTaskIndex(this.jobId);
    }

    public void closeDataAdapter() {
        this.sourceAdapter.closeDataSource();
        this.targetAdapter.closeDataSource();
    }

    public void reportSourceTableSizeInfo() {
        this.jobService.updateTableSizeInfo(this.getSourceTableSizeInfo(), this.getSourceTableMeta().getTableId());
    }

    public void storeTaskMeta(TaskMeta task) throws SQLException {
        this.jobService.storeTaskMeta(task);
    }

    public List<TaskMeta> loadTask() throws SQLException {
        return this.jobService.getTaskMeta(this);
    }

    public synchronized void storeTaskGenerator() throws SQLException {
        this.jobService.storeTaskGenerator(this.generator);
    }

    public void destroyExecutor() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(0L, TimeUnit.SECONDS);
                log.info("destroy executor success.");
            }
            catch (InterruptedException e) {
                log.warn("destroy executor failed.", (Throwable)e);
            }
        }
    }

    public LogicTableConfig getLogicTableConfig() {
        return this.logicTableConfig;
    }

    public JobStat getJobStat() {
        return this.jobStat;
    }

    public String getDateStart() {
        return this.dateStart;
    }

    public String getDateEnd() {
        return this.dateEnd;
    }

    public JobParameter getJobParameter() {
        return this.jobParameter;
    }

    public boolean isToStop() {
        return this.toStop;
    }

    public JobException getJobError() {
        return this.jobError;
    }

    public TaskGenerator getGenerator() {
        return this.generator;
    }

    public DataSourceAdapter getSourceAdapter() {
        return this.sourceAdapter;
    }

    public DataSourceAdapter getTargetAdapter() {
        return this.targetAdapter;
    }

    public TableMeta getSourceTableMeta() {
        return this.sourceTableMeta;
    }

    public TableMeta getTargetTableMeta() {
        return this.targetTableMeta;
    }

    public TableMeta getPrimaryTableMeta() {
        return this.primaryTableMeta;
    }

    public ClusterMeta getSourceCluster() {
        return this.sourceCluster;
    }

    public ClusterMeta getTargetCluster() {
        return this.targetCluster;
    }

    public TenantMeta getSourceTenant() {
        return this.sourceTenant;
    }

    public TenantMeta getTargetTenant() {
        return this.targetTenant;
    }

    public Map<String, TableMeta> getTargetTableMetaMap() {
        return this.targetTableMetaMap;
    }

    public Map<String, TableMeta> getSourceTableMetaMap() {
        return this.sourceTableMetaMap;
    }

    public String getDateConditionExpr() {
        return this.dateConditionExpr;
    }

    public Boolean getNeedPrintSqlTrace() {
        return this.needPrintSqlTrace;
    }

    public ShardingStrategy getShardingStrategy() {
        return this.shardingStrategy;
    }

    public IJobStore getJobService() {
        return this.jobService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public void setLogicTableConfig(LogicTableConfig logicTableConfig) {
        this.logicTableConfig = logicTableConfig;
    }

    public void setJobStat(JobStat jobStat) {
        this.jobStat = jobStat;
    }

    public void setDateStart(String dateStart) {
        this.dateStart = dateStart;
    }

    public void setDateEnd(String dateEnd) {
        this.dateEnd = dateEnd;
    }

    public void setJobParameter(JobParameter jobParameter) {
        this.jobParameter = jobParameter;
    }

    public void setToStop(boolean toStop) {
        this.toStop = toStop;
    }

    public void setJobError(JobException jobError) {
        this.jobError = jobError;
    }

    public void setGenerator(TaskGenerator generator) {
        this.generator = generator;
    }

    public void setSourceAdapter(DataSourceAdapter sourceAdapter) {
        this.sourceAdapter = sourceAdapter;
    }

    public void setTargetAdapter(DataSourceAdapter targetAdapter) {
        this.targetAdapter = targetAdapter;
    }

    public void setSourceTableMeta(TableMeta sourceTableMeta) {
        this.sourceTableMeta = sourceTableMeta;
    }

    public void setTargetTableMeta(TableMeta targetTableMeta) {
        this.targetTableMeta = targetTableMeta;
    }

    public void setPrimaryTableMeta(TableMeta primaryTableMeta) {
        this.primaryTableMeta = primaryTableMeta;
    }

    public void setSourceCluster(ClusterMeta sourceCluster) {
        this.sourceCluster = sourceCluster;
    }

    public void setTargetCluster(ClusterMeta targetCluster) {
        this.targetCluster = targetCluster;
    }

    public void setSourceTenant(TenantMeta sourceTenant) {
        this.sourceTenant = sourceTenant;
    }

    public void setTargetTenant(TenantMeta targetTenant) {
        this.targetTenant = targetTenant;
    }

    public void setTargetTableMetaMap(Map<String, TableMeta> targetTableMetaMap) {
        this.targetTableMetaMap = targetTableMetaMap;
    }

    public void setSourceTableMetaMap(Map<String, TableMeta> sourceTableMetaMap) {
        this.sourceTableMetaMap = sourceTableMetaMap;
    }

    public void setDateConditionExpr(String dateConditionExpr) {
        this.dateConditionExpr = dateConditionExpr;
    }

    public void setNeedPrintSqlTrace(Boolean needPrintSqlTrace) {
        this.needPrintSqlTrace = needPrintSqlTrace;
    }

    public void setShardingStrategy(ShardingStrategy shardingStrategy) {
        this.shardingStrategy = shardingStrategy;
    }

    public void setJobService(IJobStore jobService) {
        this.jobService = jobService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobMeta)) {
            return false;
        }
        JobMeta other = (JobMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        JobType this$jobType = this.getJobType();
        JobType other$jobType = other.getJobType();
        if (this$jobType == null ? other$jobType != null : !((Object)((Object)this$jobType)).equals((Object)other$jobType)) {
            return false;
        }
        JobStatus this$jobStatus = this.getJobStatus();
        JobStatus other$jobStatus = other.getJobStatus();
        if (this$jobStatus == null ? other$jobStatus != null : !((Object)((Object)this$jobStatus)).equals((Object)other$jobStatus)) {
            return false;
        }
        LogicTableConfig this$logicTableConfig = this.getLogicTableConfig();
        LogicTableConfig other$logicTableConfig = other.getLogicTableConfig();
        if (this$logicTableConfig == null ? other$logicTableConfig != null : !((Object)this$logicTableConfig).equals(other$logicTableConfig)) {
            return false;
        }
        JobStat this$jobStat = this.getJobStat();
        JobStat other$jobStat = other.getJobStat();
        if (this$jobStat == null ? other$jobStat != null : !this$jobStat.equals(other$jobStat)) {
            return false;
        }
        String this$dateStart = this.getDateStart();
        String other$dateStart = other.getDateStart();
        if (this$dateStart == null ? other$dateStart != null : !this$dateStart.equals(other$dateStart)) {
            return false;
        }
        String this$dateEnd = this.getDateEnd();
        String other$dateEnd = other.getDateEnd();
        if (this$dateEnd == null ? other$dateEnd != null : !this$dateEnd.equals(other$dateEnd)) {
            return false;
        }
        JobParameter this$jobParameter = this.getJobParameter();
        JobParameter other$jobParameter = other.getJobParameter();
        if (this$jobParameter == null ? other$jobParameter != null : !((Object)this$jobParameter).equals(other$jobParameter)) {
            return false;
        }
        if (this.isToStop() != other.isToStop()) {
            return false;
        }
        JobException this$jobError = this.getJobError();
        JobException other$jobError = other.getJobError();
        if (this$jobError == null ? other$jobError != null : !this$jobError.equals(other$jobError)) {
            return false;
        }
        TaskGenerator this$generator = this.getGenerator();
        TaskGenerator other$generator = other.getGenerator();
        if (this$generator == null ? other$generator != null : !((Object)this$generator).equals(other$generator)) {
            return false;
        }
        DataSourceAdapter this$sourceAdapter = this.getSourceAdapter();
        DataSourceAdapter other$sourceAdapter = other.getSourceAdapter();
        if (this$sourceAdapter == null ? other$sourceAdapter != null : !this$sourceAdapter.equals(other$sourceAdapter)) {
            return false;
        }
        DataSourceAdapter this$targetAdapter = this.getTargetAdapter();
        DataSourceAdapter other$targetAdapter = other.getTargetAdapter();
        if (this$targetAdapter == null ? other$targetAdapter != null : !this$targetAdapter.equals(other$targetAdapter)) {
            return false;
        }
        TableMeta this$sourceTableMeta = this.getSourceTableMeta();
        TableMeta other$sourceTableMeta = other.getSourceTableMeta();
        if (this$sourceTableMeta == null ? other$sourceTableMeta != null : !((Object)this$sourceTableMeta).equals(other$sourceTableMeta)) {
            return false;
        }
        TableMeta this$targetTableMeta = this.getTargetTableMeta();
        TableMeta other$targetTableMeta = other.getTargetTableMeta();
        if (this$targetTableMeta == null ? other$targetTableMeta != null : !((Object)this$targetTableMeta).equals(other$targetTableMeta)) {
            return false;
        }
        TableMeta this$primaryTableMeta = this.getPrimaryTableMeta();
        TableMeta other$primaryTableMeta = other.getPrimaryTableMeta();
        if (this$primaryTableMeta == null ? other$primaryTableMeta != null : !((Object)this$primaryTableMeta).equals(other$primaryTableMeta)) {
            return false;
        }
        ClusterMeta this$sourceCluster = this.getSourceCluster();
        ClusterMeta other$sourceCluster = other.getSourceCluster();
        if (this$sourceCluster == null ? other$sourceCluster != null : !((Object)this$sourceCluster).equals(other$sourceCluster)) {
            return false;
        }
        ClusterMeta this$targetCluster = this.getTargetCluster();
        ClusterMeta other$targetCluster = other.getTargetCluster();
        if (this$targetCluster == null ? other$targetCluster != null : !((Object)this$targetCluster).equals(other$targetCluster)) {
            return false;
        }
        TenantMeta this$sourceTenant = this.getSourceTenant();
        TenantMeta other$sourceTenant = other.getSourceTenant();
        if (this$sourceTenant == null ? other$sourceTenant != null : !((Object)this$sourceTenant).equals(other$sourceTenant)) {
            return false;
        }
        TenantMeta this$targetTenant = this.getTargetTenant();
        TenantMeta other$targetTenant = other.getTargetTenant();
        if (this$targetTenant == null ? other$targetTenant != null : !((Object)this$targetTenant).equals(other$targetTenant)) {
            return false;
        }
        Map<String, TableMeta> this$targetTableMetaMap = this.getTargetTableMetaMap();
        Map<String, TableMeta> other$targetTableMetaMap = other.getTargetTableMetaMap();
        if (this$targetTableMetaMap == null ? other$targetTableMetaMap != null : !((Object)this$targetTableMetaMap).equals(other$targetTableMetaMap)) {
            return false;
        }
        Map<String, TableMeta> this$sourceTableMetaMap = this.getSourceTableMetaMap();
        Map<String, TableMeta> other$sourceTableMetaMap = other.getSourceTableMetaMap();
        if (this$sourceTableMetaMap == null ? other$sourceTableMetaMap != null : !((Object)this$sourceTableMetaMap).equals(other$sourceTableMetaMap)) {
            return false;
        }
        String this$dateConditionExpr = this.getDateConditionExpr();
        String other$dateConditionExpr = other.getDateConditionExpr();
        if (this$dateConditionExpr == null ? other$dateConditionExpr != null : !this$dateConditionExpr.equals(other$dateConditionExpr)) {
            return false;
        }
        Boolean this$needPrintSqlTrace = this.getNeedPrintSqlTrace();
        Boolean other$needPrintSqlTrace = other.getNeedPrintSqlTrace();
        if (this$needPrintSqlTrace == null ? other$needPrintSqlTrace != null : !((Object)this$needPrintSqlTrace).equals(other$needPrintSqlTrace)) {
            return false;
        }
        ShardingStrategy this$shardingStrategy = this.getShardingStrategy();
        ShardingStrategy other$shardingStrategy = other.getShardingStrategy();
        if (this$shardingStrategy == null ? other$shardingStrategy != null : !((Object)((Object)this$shardingStrategy)).equals((Object)other$shardingStrategy)) {
            return false;
        }
        IJobStore this$jobService = this.getJobService();
        IJobStore other$jobService = other.getJobService();
        if (this$jobService == null ? other$jobService != null : !this$jobService.equals(other$jobService)) {
            return false;
        }
        ExecutorService this$executorService = this.getExecutorService();
        ExecutorService other$executorService = other.getExecutorService();
        return !(this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        JobType $jobType = this.getJobType();
        result = result * 59 + ($jobType == null ? 43 : ((Object)((Object)$jobType)).hashCode());
        JobStatus $jobStatus = this.getJobStatus();
        result = result * 59 + ($jobStatus == null ? 43 : ((Object)((Object)$jobStatus)).hashCode());
        LogicTableConfig $logicTableConfig = this.getLogicTableConfig();
        result = result * 59 + ($logicTableConfig == null ? 43 : ((Object)$logicTableConfig).hashCode());
        JobStat $jobStat = this.getJobStat();
        result = result * 59 + ($jobStat == null ? 43 : $jobStat.hashCode());
        String $dateStart = this.getDateStart();
        result = result * 59 + ($dateStart == null ? 43 : $dateStart.hashCode());
        String $dateEnd = this.getDateEnd();
        result = result * 59 + ($dateEnd == null ? 43 : $dateEnd.hashCode());
        JobParameter $jobParameter = this.getJobParameter();
        result = result * 59 + ($jobParameter == null ? 43 : ((Object)$jobParameter).hashCode());
        result = result * 59 + (this.isToStop() ? 79 : 97);
        JobException $jobError = this.getJobError();
        result = result * 59 + ($jobError == null ? 43 : $jobError.hashCode());
        TaskGenerator $generator = this.getGenerator();
        result = result * 59 + ($generator == null ? 43 : ((Object)$generator).hashCode());
        DataSourceAdapter $sourceAdapter = this.getSourceAdapter();
        result = result * 59 + ($sourceAdapter == null ? 43 : $sourceAdapter.hashCode());
        DataSourceAdapter $targetAdapter = this.getTargetAdapter();
        result = result * 59 + ($targetAdapter == null ? 43 : $targetAdapter.hashCode());
        TableMeta $sourceTableMeta = this.getSourceTableMeta();
        result = result * 59 + ($sourceTableMeta == null ? 43 : ((Object)$sourceTableMeta).hashCode());
        TableMeta $targetTableMeta = this.getTargetTableMeta();
        result = result * 59 + ($targetTableMeta == null ? 43 : ((Object)$targetTableMeta).hashCode());
        TableMeta $primaryTableMeta = this.getPrimaryTableMeta();
        result = result * 59 + ($primaryTableMeta == null ? 43 : ((Object)$primaryTableMeta).hashCode());
        ClusterMeta $sourceCluster = this.getSourceCluster();
        result = result * 59 + ($sourceCluster == null ? 43 : ((Object)$sourceCluster).hashCode());
        ClusterMeta $targetCluster = this.getTargetCluster();
        result = result * 59 + ($targetCluster == null ? 43 : ((Object)$targetCluster).hashCode());
        TenantMeta $sourceTenant = this.getSourceTenant();
        result = result * 59 + ($sourceTenant == null ? 43 : ((Object)$sourceTenant).hashCode());
        TenantMeta $targetTenant = this.getTargetTenant();
        result = result * 59 + ($targetTenant == null ? 43 : ((Object)$targetTenant).hashCode());
        Map<String, TableMeta> $targetTableMetaMap = this.getTargetTableMetaMap();
        result = result * 59 + ($targetTableMetaMap == null ? 43 : ((Object)$targetTableMetaMap).hashCode());
        Map<String, TableMeta> $sourceTableMetaMap = this.getSourceTableMetaMap();
        result = result * 59 + ($sourceTableMetaMap == null ? 43 : ((Object)$sourceTableMetaMap).hashCode());
        String $dateConditionExpr = this.getDateConditionExpr();
        result = result * 59 + ($dateConditionExpr == null ? 43 : $dateConditionExpr.hashCode());
        Boolean $needPrintSqlTrace = this.getNeedPrintSqlTrace();
        result = result * 59 + ($needPrintSqlTrace == null ? 43 : ((Object)$needPrintSqlTrace).hashCode());
        ShardingStrategy $shardingStrategy = this.getShardingStrategy();
        result = result * 59 + ($shardingStrategy == null ? 43 : ((Object)((Object)$shardingStrategy)).hashCode());
        IJobStore $jobService = this.getJobService();
        result = result * 59 + ($jobService == null ? 43 : $jobService.hashCode());
        ExecutorService $executorService = this.getExecutorService();
        result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        return result;
    }
}

