/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.stat;

import com.oceanbase.tools.migrator.common.util.TimeUtils;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class JobStat {
    private long putWaitTimeUs = 0L;
    private long putTimes = 0L;
    private long takeWaitTimeUs = 0L;
    private long takeTimes = 0L;
    private AtomicLong dataSize = new AtomicLong();
    private AtomicLong rowCount = new AtomicLong();
    private long readRowCount = 0L;
    private long totalRowCount = 0L;
    private long elapsedTime = 0L;
    private long lastDataSize = 0L;
    private long lastRowCount = 0L;
    private long lastReadRowCount = 0L;
    private long avgDataSize = 0L;
    private long avgRowCount = 0L;
    private long avgReadRowCount = 0L;
    private long putRowLimitWaitTimeUs = 0L;
    private long putSizeLimitWaitTimeUs = 0L;
    private long taskRowLimitWaitTimeUs = 0L;
    private long taskSizeLimitWaitTimeUs = 0L;
    private long lastReportTimeUs = 0L;
    private long unMatchedRowCount = 0L;

    public long getPutWaitTimeUs() {
        return this.putWaitTimeUs;
    }

    public void addPutWaitTimeUs(long putWaitTimeUs) {
        this.putWaitTimeUs += putWaitTimeUs;
    }

    public void addElapsedTime(long elapsedTime) {
        this.elapsedTime += elapsedTime;
    }

    public long getTotalAvgDataSize() {
        return this.elapsedTime == 0L ? 0L : this.dataSize.get() / this.elapsedTime;
    }

    public long getPutTimes() {
        return this.putTimes;
    }

    public void incPutTimes() {
        ++this.putTimes;
    }

    public long getTakeWaitTimeUs() {
        return this.takeWaitTimeUs;
    }

    public void addTakeWaitTimeUs(long takeWaitTimeUs) {
        this.takeWaitTimeUs += takeWaitTimeUs;
    }

    public long getTakeTimes() {
        return this.takeTimes;
    }

    public void incTakeTimes() {
        ++this.takeTimes;
    }

    public long getDataSize() {
        return this.dataSize.get();
    }

    public void setDataSize(long dataSize) {
        this.dataSize = new AtomicLong(dataSize);
    }

    public void addDataSize(long dataSize) {
        this.dataSize.addAndGet(dataSize);
    }

    public long getRowCount() {
        return this.rowCount.get();
    }

    public void setRowCount(long rowCount) {
        this.rowCount = new AtomicLong(rowCount);
    }

    public void addRowCount(long rowCount) {
        this.rowCount.addAndGet(rowCount);
    }

    public void addReadRowCount(long readRowCount) {
        this.readRowCount += readRowCount;
    }

    public void setReadRowCount(long readRowCount) {
        this.readRowCount = readRowCount;
    }

    public long getReadRowCount() {
        return this.readRowCount;
    }

    public long getTotalRowCount() {
        return this.totalRowCount;
    }

    public void setTotalRowCount(long totalRowCount) {
        this.totalRowCount = totalRowCount;
    }

    public long getAvgReadRowCount() {
        return this.avgReadRowCount;
    }

    public long getAvgDataSize() {
        return this.avgDataSize;
    }

    public void setAvgDataSize(long avgDataSize) {
        this.avgDataSize = avgDataSize;
    }

    public long getUnMatchedRowCount() {
        return this.unMatchedRowCount;
    }

    public void setUnMatchedRowCount(long unMatchedRowCount) {
        this.unMatchedRowCount = unMatchedRowCount;
    }

    public long getAvgRowCount() {
        return this.avgRowCount;
    }

    public void setAvgRowCount(long avgRowCount) {
        this.avgRowCount = avgRowCount;
    }

    public long getPutRowLimitWaitTimeUs() {
        return this.putRowLimitWaitTimeUs;
    }

    public void addPutRowLimitWaitTimeUs(long putRowLimitWaitTimeUs) {
        this.putRowLimitWaitTimeUs += putRowLimitWaitTimeUs;
    }

    public long getPutSizeLimitWaitTimeUs() {
        return this.putSizeLimitWaitTimeUs;
    }

    public void addPutSizeLimitWaitTimeUs(long putSizeLimitWaitTimeUs) {
        this.putSizeLimitWaitTimeUs += putSizeLimitWaitTimeUs;
    }

    public long getTaskRowLimitWaitTimeUs() {
        return this.taskRowLimitWaitTimeUs;
    }

    public void addTaskRowLimitWaitTimeUs(long taskRowLimitWaitTimeUs) {
        this.taskRowLimitWaitTimeUs += taskRowLimitWaitTimeUs;
    }

    public long getTaskSizeLimitWaitTimeUs() {
        return this.taskSizeLimitWaitTimeUs;
    }

    public void addTaskSizeLimitWaitTimeUs(long taskSizeLimitWaitTimeUs) {
        this.taskSizeLimitWaitTimeUs += taskSizeLimitWaitTimeUs;
    }

    public void addUnMatchedRowCount(long rowCount) {
        this.unMatchedRowCount += rowCount;
    }

    public void buildReportData() {
        long currentTimeUs = TimeUtils.getNanoTimeUs();
        long reportInterval = (currentTimeUs - this.lastReportTimeUs) / 1000L / 1000L;
        reportInterval = reportInterval > 0L ? reportInterval : 1L;
        this.avgDataSize = (this.dataSize.get() - this.lastDataSize) / reportInterval;
        this.avgRowCount = (this.rowCount.get() - this.lastRowCount) / reportInterval;
        this.avgReadRowCount = (this.readRowCount - this.lastReadRowCount) / reportInterval;
        this.lastDataSize = this.dataSize.get();
        this.lastRowCount = this.rowCount.get();
        this.lastReadRowCount = this.readRowCount;
        this.lastReportTimeUs = currentTimeUs;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("dataSize", (Object)this.dataSize).append("rowCount", (Object)this.rowCount).append("readRowCount", this.readRowCount).append("avgDataSize", this.avgDataSize).append("avgRowCount", this.avgRowCount).append("avgReadRowCount", this.avgReadRowCount).append("putWaitTimeUs", this.putWaitTimeUs).append("takeWaitTimeUs", this.takeWaitTimeUs).append("putRowLimitWaitTimeUs", this.putRowLimitWaitTimeUs).append("putSizeLimitWaitTimeUs", this.putSizeLimitWaitTimeUs).append("taskRowLimitWaitTimeUs", this.taskRowLimitWaitTimeUs).append("taskSizeLimitWaitTimeUs", this.taskSizeLimitWaitTimeUs).append("totalAvgDataSize", this.getTotalAvgDataSize()).toString();
    }
}

